/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.pattern;

import com.firefly.utils.StringUtils;

public abstract class Pattern {
    private static final AllMatch ALL_MATCH = new AllMatch();

    public abstract String[] match(String var1);

    public static Pattern compile(String pattern, String wildcard) {
        boolean startWith = pattern.startsWith(wildcard);
        boolean endWith = pattern.endsWith(wildcard);
        String[] array = StringUtils.split(pattern, wildcard);
        switch (array.length) {
            case 0: {
                return ALL_MATCH;
            }
            case 1: {
                if (startWith && endWith) {
                    return new HeadAndTailMatch(array[0]);
                }
                if (startWith) {
                    return new HeadMatch(array[0]);
                }
                if (endWith) {
                    return new TailMatch(array[0]);
                }
                return new EqualsMatch(pattern);
            }
        }
        return new MultipartMatch(startWith, endWith, array);
    }

    private static class AllMatch
    extends Pattern {
        private AllMatch() {
        }

        @Override
        public String[] match(String str) {
            return new String[]{str};
        }
    }

    private static class EqualsMatch
    extends Pattern {
        private final String pattern;

        public EqualsMatch(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public String[] match(String str) {
            return this.pattern.equals(str) ? new String[]{} : null;
        }
    }

    private static class HeadAndTailMatch
    extends Pattern {
        private final String part;

        public HeadAndTailMatch(String part) {
            this.part = part;
        }

        @Override
        public String[] match(String str) {
            int currentIndex = str.indexOf(this.part);
            if (currentIndex >= 0) {
                String[] ret = new String[]{str.substring(0, currentIndex), str.substring(currentIndex + this.part.length(), str.length())};
                return ret;
            }
            return null;
        }
    }

    private static class HeadMatch
    extends Pattern {
        private final String part;

        public HeadMatch(String part) {
            this.part = part;
        }

        @Override
        public String[] match(String str) {
            int currentIndex = str.indexOf(this.part);
            if (currentIndex + this.part.length() == str.length()) {
                return new String[]{str.substring(0, currentIndex)};
            }
            return null;
        }
    }

    private static class TailMatch
    extends Pattern {
        private final String part;

        public TailMatch(String part) {
            this.part = part;
        }

        @Override
        public String[] match(String str) {
            int currentIndex = str.indexOf(this.part);
            if (currentIndex == 0) {
                return new String[]{str.substring(this.part.length())};
            }
            return null;
        }
    }

    private static class MultipartMatch
    extends Pattern {
        private final boolean startWith;
        private final boolean endWith;
        private final String[] parts;
        private int num;

        public MultipartMatch(boolean startWith, boolean endWith, String[] parts) {
            this.startWith = startWith;
            this.endWith = endWith;
            this.parts = parts;
            this.num = parts.length - 1;
            if (startWith) {
                ++this.num;
            }
            if (endWith) {
                ++this.num;
            }
        }

        @Override
        public String[] match(String str) {
            int currentIndex = -1;
            int lastIndex = -1;
            String[] ret = new String[this.num];
            for (int i = 0; i < this.parts.length; ++i) {
                String part = this.parts[i];
                int j = this.startWith ? i : i - 1;
                currentIndex = str.indexOf(part, lastIndex + 1);
                if (currentIndex > lastIndex) {
                    if (i != 0 || this.startWith) {
                        ret[j] = str.substring(lastIndex + 1, currentIndex);
                    }
                } else {
                    return null;
                }
                lastIndex = currentIndex + part.length() - 1;
            }
            if (this.endWith) {
                ret[this.num - 1] = str.substring(lastIndex + 1);
            }
            return ret;
        }
    }
}

