/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.log.file;

import com.firefly.utils.VerifyUtils;
import com.firefly.utils.collection.Trie;
import com.firefly.utils.lang.AbstractLifeCycle;
import com.firefly.utils.log.Log;
import com.firefly.utils.log.LogFactory;
import com.firefly.utils.log.LogItem;
import com.firefly.utils.log.LogTask;
import com.firefly.utils.log.file.FileLog;
import com.firefly.utils.time.Millisecond100Clock;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;

public class FileLogTask
extends AbstractLifeCycle
implements LogTask {
    private BlockingQueue<LogItem> queue = new LinkedTransferQueue<LogItem>();
    private Thread thread = new Thread((Runnable)this, "firefly log thread");
    private final Trie<Log> logTree;

    public FileLogTask(Trie<Log> logTree) {
        this.thread.setPriority(1);
        this.logTree = logTree;
    }

    private long flushAllPerSecond(long lastFlushedTime) {
        long timeDifference = Millisecond100Clock.currentTimeMillis() - lastFlushedTime;
        if (timeDifference > 1000L) {
            LogFactory.getInstance().flushAll();
            return Millisecond100Clock.currentTimeMillis();
        }
        return lastFlushedTime;
    }

    @Override
    public void run() {
        long lastFlushedTime = Millisecond100Clock.currentTimeMillis();
        do {
            try {
                LogItem logItem = null;
                while ((logItem = this.queue.poll(1000L, TimeUnit.MILLISECONDS)) != null) {
                    Log log = LogFactory.getInstance().getLog(logItem.getName());
                    if (log instanceof FileLog) {
                        ((FileLog)log).write(logItem);
                    }
                    lastFlushedTime = this.flushAllPerSecond(lastFlushedTime);
                }
                lastFlushedTime = this.flushAllPerSecond(lastFlushedTime);
            }
            catch (Throwable e) {
                e.printStackTrace();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        } while (this.start || !this.queue.isEmpty());
        for (String key : this.logTree.keySet()) {
            Log log = this.logTree.get(key);
            if (!(log instanceof FileLog)) continue;
            ((FileLog)log).close();
        }
    }

    @Override
    public void add(LogItem logItem) {
        if (!this.start) {
            return;
        }
        if (VerifyUtils.isEmpty(logItem.getName())) {
            throw new IllegalArgumentException("log name is empty");
        }
        this.queue.offer(logItem);
    }

    @Override
    protected void init() {
        this.start = true;
        this.thread.start();
    }

    @Override
    protected void destroy() {
        this.start = false;
    }
}

