/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.log.file;

import com.firefly.utils.log.Log;
import com.firefly.utils.log.LogFactory;
import com.firefly.utils.log.LogItem;
import com.firefly.utils.log.LogLevel;
import com.firefly.utils.time.SafeSimpleDateFormat;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class FileLog
implements Log,
Closeable {
    private LogLevel level;
    private String path;
    private String name;
    private boolean consoleOutput;
    private boolean fileOutput;
    private int maxFileSize;
    private BufferedWriter bufferedWriter;
    private String currentDate = LogFactory.DAY_DATE_FORMAT.format(new Date());
    private static final int bufferSize = 4096;
    private static final boolean stackTrace = Boolean.getBoolean("debugMode");

    void write(LogItem logItem) {
        if (this.consoleOutput) {
            logItem.setDate(SafeSimpleDateFormat.defaultDateFormat.format(new Date()));
            System.out.println(logItem.toString());
        }
        if (this.fileOutput) {
            Date d = new Date();
            boolean success = this.getBufferedWriter(LogFactory.DAY_DATE_FORMAT.format(d));
            if (success) {
                logItem.setDate(SafeSimpleDateFormat.defaultDateFormat.format(d));
                try {
                    this.bufferedWriter.append(logItem.toString() + "\r\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.err.println("The log " + this.toString() + " can not get buffered writer!");
            }
        }
    }

    public void flush() {
        if (this.bufferedWriter != null) {
            try {
                this.bufferedWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() {
        if (this.bufferedWriter != null) {
            try {
                this.bufferedWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean createNewBufferedWriter(String newDate) {
        File file = new File(this.path, this.name + "." + newDate + ".txt");
        try {
            this.bufferedWriter = new BufferedWriter(new FileWriter(file, true), 4096);
            this.currentDate = newDate;
            System.out.println("get new log buffer, the file path is " + file.getAbsolutePath());
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean getBufferedWriter(String newDate) {
        if (this.bufferedWriter == null) {
            return this.createNewBufferedWriter(newDate);
        }
        if (!this.currentDate.equals(newDate)) {
            this.close();
            return this.createNewBufferedWriter(newDate);
        }
        return true;
    }

    public void setConsoleOutput(boolean consoleOutput) {
        this.consoleOutput = consoleOutput;
    }

    public void setFileOutput(boolean fileOutput) {
        this.fileOutput = fileOutput;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public void setLevel(LogLevel level) {
        this.level = level;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    private void add(String str, String level, Throwable throwable, Object ... objs) {
        LogItem item = new LogItem();
        item.setLevel(level);
        item.setName(this.name);
        item.setContent(str);
        item.setObjs(objs);
        item.setThrowable(throwable);
        if (stackTrace) {
            item.setStackTraceElement(FileLog.getStackTraceElement());
        }
        LogFactory.getInstance().getLogTask().add(item);
    }

    @Override
    public void trace(String str) {
        if (!this.isTraceEnabled()) {
            return;
        }
        this.add(str, LogLevel.TRACE.getName(), null, new Object[0]);
    }

    @Override
    public void trace(String str, Object ... objs) {
        if (!this.isTraceEnabled()) {
            return;
        }
        this.add(str, LogLevel.TRACE.getName(), null, objs);
    }

    @Override
    public void trace(String str, Throwable throwable, Object ... objs) {
        if (!this.isTraceEnabled()) {
            return;
        }
        this.add(str, LogLevel.TRACE.getName(), null, objs);
    }

    @Override
    public void debug(String str) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.add(str, LogLevel.DEBUG.getName(), null, new Object[0]);
    }

    @Override
    public void debug(String str, Object ... objs) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.add(str, LogLevel.DEBUG.getName(), null, objs);
    }

    @Override
    public void debug(String str, Throwable throwable, Object ... objs) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.add(str, LogLevel.DEBUG.getName(), throwable, objs);
    }

    @Override
    public void info(String str) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.add(str, LogLevel.INFO.getName(), null, new Object[0]);
    }

    @Override
    public void info(String str, Object ... objs) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.add(str, LogLevel.INFO.getName(), null, objs);
    }

    @Override
    public void info(String str, Throwable throwable, Object ... objs) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.add(str, LogLevel.INFO.getName(), throwable, objs);
    }

    @Override
    public void warn(String str) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.add(str, LogLevel.WARN.getName(), null, new Object[0]);
    }

    @Override
    public void warn(String str, Object ... objs) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.add(str, LogLevel.WARN.getName(), null, objs);
    }

    @Override
    public void warn(String str, Throwable throwable, Object ... objs) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.add(str, LogLevel.WARN.getName(), throwable, objs);
    }

    @Override
    public void error(String str, Object ... objs) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.add(str, LogLevel.ERROR.getName(), null, objs);
    }

    @Override
    public void error(String str, Throwable throwable, Object ... objs) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.add(str, LogLevel.ERROR.getName(), throwable, objs);
    }

    @Override
    public void error(String str) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.add(str, LogLevel.ERROR.getName(), null, new Object[0]);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level.isEnabled(LogLevel.TRACE);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level.isEnabled(LogLevel.DEBUG);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.level.isEnabled(LogLevel.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.level.isEnabled(LogLevel.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.level.isEnabled(LogLevel.ERROR);
    }

    public String toString() {
        return "[level=" + this.level.getName() + ", name=" + this.name + ", path=" + this.path + ", consoleOutput=" + this.consoleOutput + ", fileOutput=" + this.fileOutput + ", maxFileSize=" + this.maxFileSize + "]";
    }

    public static StackTraceElement getStackTraceElement() {
        return Thread.currentThread().getStackTrace()[4];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.consoleOutput ? 1231 : 1237);
        result = 31 * result + (this.fileOutput ? 1231 : 1237);
        result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
        result = 31 * result + this.maxFileSize;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileLog other = (FileLog)obj;
        if (this.consoleOutput != other.consoleOutput) {
            return false;
        }
        if (this.fileOutput != other.fileOutput) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        if (this.maxFileSize != other.maxFileSize) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

