/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.log;

import com.firefly.utils.ConvertUtils;
import com.firefly.utils.dom.DefaultDom;
import com.firefly.utils.function.Action1;
import com.firefly.utils.log.AbstractLogConfigParser;
import com.firefly.utils.log.file.FileLog;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlLogConfigParser
extends AbstractLogConfigParser {
    @Override
    public boolean parse(Action1<FileLog> action) {
        DefaultDom dom = new DefaultDom();
        Document doc = dom.getDocument("firefly-log.xml");
        if (doc == null) {
            return false;
        }
        Element root = dom.getRoot(doc);
        List<Element> loggerList = dom.elements(root, "logger");
        if (loggerList == null || loggerList.isEmpty()) {
            return false;
        }
        for (Element e : loggerList) {
            String name = dom.getTextValueByTagName(e, "name", "firefly-system");
            String level = dom.getTextValueByTagName(e, "level", "INFO");
            String path = dom.getTextValueByTagName(e, "path", DEFAULT_LOG_DIRECTORY.getAbsolutePath());
            boolean consoleEnabled = ConvertUtils.convert(dom.getTextValueByTagName(e, "enable-console"), false);
            int maxFileSize = ConvertUtils.convert(dom.getTextValueByTagName(e, "max-file-size"), 0xC800000);
            action.call(this.createLog(name, level, path, consoleEnabled, maxFileSize));
        }
        return true;
    }
}

