/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.log;

import com.firefly.utils.StringUtils;
import com.firefly.utils.function.Action1;
import com.firefly.utils.log.AbstractLogConfigParser;
import com.firefly.utils.log.LogFactory;
import com.firefly.utils.log.file.FileLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class PropertiesLogConfigParser
extends AbstractLogConfigParser {
    @Override
    public boolean parse(Action1<FileLog> action) {
        try {
            Properties properties = this.loadLogConfigurationFile();
            if (properties != null) {
                this.parseProperties(properties, action);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private Properties loadLogConfigurationFile() throws IOException {
        Properties properties = new Properties();
        try (InputStream input = LogFactory.class.getClassLoader().getResourceAsStream("firefly-log.properties");){
            if (input == null) {
                Properties properties2 = null;
                return properties2;
            }
            properties.load(input);
        }
        return properties;
    }

    private void parseProperties(Properties properties, Action1<FileLog> fileLog) {
        block5: for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            String[] strs = StringUtils.split(value, ',');
            switch (strs.length) {
                case 1: {
                    fileLog.call(this.createLog(name, strs[0], null, false, 0xC800000));
                    continue block5;
                }
                case 2: {
                    if ("console".equalsIgnoreCase(strs[1])) {
                        fileLog.call(this.createLog(name, strs[0], null, true, 0xC800000));
                        continue block5;
                    }
                    fileLog.call(this.createLog(name, strs[0], strs[1], false, 0xC800000));
                    continue block5;
                }
                case 3: {
                    fileLog.call(this.createLog(name, strs[0], strs[1], "console".equalsIgnoreCase(strs[2]), 0xC800000));
                    continue block5;
                }
            }
            System.err.println("The log " + name + " configuration format is illegal. It will use default log configuration");
            fileLog.call(this.createLog(name, "INFO", null, false, 0xC800000));
        }
    }
}

