/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.log;

import java.util.HashMap;
import java.util.Map;

public enum LogLevel {
    TRACE(0, "TRACE"),
    DEBUG(1, "DEBUG"),
    INFO(2, "INFO"),
    WARN(3, "WARN"),
    ERROR(4, "ERROR");

    private final int level;
    private final String name;
    private static final LogLevel[] levels;
    private static final Map<String, LogLevel> levelNameMap;

    private LogLevel(int level, String name) {
        this.level = level;
        this.name = name;
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled(LogLevel logLevel) {
        return this.level <= logLevel.level;
    }

    public static LogLevel fromLevel(int level) {
        if (level >= 0 && level < levels.length) {
            return levels[level];
        }
        return INFO;
    }

    public static LogLevel fromName(String name) {
        if (name == null) {
            return INFO;
        }
        LogLevel logLevel = levelNameMap.get(name);
        if (logLevel == null) {
            return INFO;
        }
        return levelNameMap.get(name);
    }

    static {
        levels = new LogLevel[5];
        levelNameMap = new HashMap<String, LogLevel>();
        LogLevel[] logLevelArray = LogLevel.values();
        int n = logLevelArray.length;
        for (int i = 0; i < n; ++i) {
            LogLevel logLevel;
            LogLevel.levels[logLevel.level] = logLevel = logLevelArray[i];
            levelNameMap.put(logLevel.name, logLevel);
        }
    }
}

