/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.log;

import com.firefly.utils.collection.TreeTrie;
import com.firefly.utils.collection.Trie;
import com.firefly.utils.lang.AbstractLifeCycle;
import com.firefly.utils.log.AbstractLogConfigParser;
import com.firefly.utils.log.Log;
import com.firefly.utils.log.LogTask;
import com.firefly.utils.log.PropertiesLogConfigParser;
import com.firefly.utils.log.XmlLogConfigParser;
import com.firefly.utils.log.file.FileLog;
import com.firefly.utils.log.file.FileLogTask;
import com.firefly.utils.time.Millisecond100Clock;
import com.firefly.utils.time.SafeSimpleDateFormat;

public class LogFactory
extends AbstractLifeCycle {
    public static final SafeSimpleDateFormat DAY_DATE_FORMAT = new SafeSimpleDateFormat("yyyy-MM-dd");
    private final Trie<Log> logTree = new TreeTrie<Log>();
    private final LogTask logTask = new FileLogTask(this.logTree);

    public static LogFactory getInstance() {
        return Holder.instance;
    }

    private LogFactory() {
        AbstractLogConfigParser parser = new XmlLogConfigParser();
        boolean success = parser.parse(fileLog -> this.logTree.put(fileLog.getName(), (Log)fileLog));
        if (!success) {
            parser = new PropertiesLogConfigParser();
            success = parser.parse(fileLog -> this.logTree.put(fileLog.getName(), (Log)fileLog));
        }
        if (!success) {
            System.out.println("log configuration parsing failure!");
        }
        if (this.logTree.get("firefly-system") == null) {
            FileLog fileLog2 = parser.createDefaultLog();
            this.logTree.put(fileLog2.getName(), fileLog2);
        }
        this.start();
    }

    public void flushAll() {
        for (String key : this.logTree.keySet()) {
            Log log = this.logTree.get(key);
            if (!(log instanceof FileLog)) continue;
            ((FileLog)log).flush();
        }
    }

    public Log getLog(Class<?> clazz) {
        return this.getLog(clazz.getName());
    }

    public Log getLog(String name) {
        Log log = this.logTree.getBest(name);
        if (log != null) {
            return log;
        }
        return this.logTree.get("firefly-system");
    }

    public LogTask getLogTask() {
        return this.logTask;
    }

    @Override
    protected void init() {
        this.logTask.start();
    }

    @Override
    protected void destroy() {
        this.logTask.stop();
        Millisecond100Clock.stop();
    }

    private static class Holder {
        private static LogFactory instance = new LogFactory();

        private Holder() {
        }
    }
}

