/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.lang.pool;

import com.firefly.utils.lang.AbstractLifeCycle;
import com.firefly.utils.lang.pool.BlockingPool;
import com.firefly.utils.lang.pool.ObjectFactory;
import com.firefly.utils.lang.pool.Pool;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BoundedBlockingPool<T>
extends AbstractLifeCycle
implements BlockingPool<T> {
    private BlockingQueue<T> queue;
    private int initSize;
    private ObjectFactory<T> factory;
    private Pool.Validator<T> validator;
    private Pool.Dispose<T> dispose;

    public BoundedBlockingPool(int initSize, int maxSize, ObjectFactory<T> factory, Pool.Validator<T> validator, Pool.Dispose<T> dispose) {
        this(initSize, new LinkedBlockingQueue(maxSize), factory, validator, dispose);
    }

    public BoundedBlockingPool(int initSize, BlockingQueue<T> queue, ObjectFactory<T> factory, Pool.Validator<T> validator, Pool.Dispose<T> dispose) {
        this.initSize = initSize;
        this.factory = factory;
        this.validator = validator;
        this.dispose = dispose;
        this.queue = queue;
    }

    @Override
    public T get() {
        this.start();
        Object t = this.queue.poll();
        return (T)this._take(t);
    }

    @Override
    public T take() throws InterruptedException {
        this.start();
        T t = this.queue.take();
        return this._take(t);
    }

    @Override
    public T take(long time, TimeUnit unit) throws InterruptedException {
        this.start();
        T t = this.queue.poll(time, unit);
        return this._take(t);
    }

    private T _take(T t) {
        if (t == null) {
            return this.factory.createNew();
        }
        if (this.validator.isValid(t)) {
            return t;
        }
        return this.factory.createNew();
    }

    @Override
    public void release(T t) {
        if (this.validator.isValid(t)) {
            boolean success = this.queue.offer(t);
            if (!success) {
                this.dispose.destroy(t);
            }
        } else {
            this.dispose.destroy(t);
        }
    }

    @Override
    public void put(T t) throws InterruptedException {
        if (this.validator.isValid(t)) {
            this.queue.put(t);
        } else {
            this.dispose.destroy(t);
        }
    }

    @Override
    public boolean put(T t, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.validator.isValid(t)) {
            boolean success = this.queue.offer(t, timeout, unit);
            if (!success) {
                this.dispose.destroy(t);
            }
            return success;
        }
        this.dispose.destroy(t);
        return false;
    }

    @Override
    protected void init() {
        for (int i = 0; i < this.initSize; ++i) {
            this.queue.offer(this.factory.createNew());
        }
    }

    @Override
    protected void destroy() {
        Object t = null;
        while (true) {
            Object e = this.queue.poll();
            t = e;
            if (e == null) break;
            this.dispose.destroy(t);
        }
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public void cleanup() {
        Iterator iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            if (this.validator.isValid(t)) continue;
            iterator.remove();
            this.dispose.destroy(t);
        }
    }
}

