/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.serializer;

import com.firefly.utils.collection.IdentityHashMap;
import com.firefly.utils.json.JsonWriter;
import com.firefly.utils.json.Serializer;
import com.firefly.utils.json.annotation.CircularReferenceCheck;
import com.firefly.utils.json.annotation.DateFormat;
import com.firefly.utils.json.serializer.ArraySerializer;
import com.firefly.utils.json.serializer.BoolSerializer;
import com.firefly.utils.json.serializer.BooleanArraySerializer;
import com.firefly.utils.json.serializer.ByteArraySerializer;
import com.firefly.utils.json.serializer.ByteSerializer;
import com.firefly.utils.json.serializer.CharArraySerializer;
import com.firefly.utils.json.serializer.CharacterSerializer;
import com.firefly.utils.json.serializer.CollectionSerializer;
import com.firefly.utils.json.serializer.DateSerializer;
import com.firefly.utils.json.serializer.DynamicObjectSerializer;
import com.firefly.utils.json.serializer.EnumSerializer;
import com.firefly.utils.json.serializer.IntSerializer;
import com.firefly.utils.json.serializer.IntegerArraySerializer;
import com.firefly.utils.json.serializer.LongArraySerializer;
import com.firefly.utils.json.serializer.LongSerializer;
import com.firefly.utils.json.serializer.MapSerializer;
import com.firefly.utils.json.serializer.ObjectNoCheckSerializer;
import com.firefly.utils.json.serializer.ObjectSerializer;
import com.firefly.utils.json.serializer.ShortArraySerializer;
import com.firefly.utils.json.serializer.ShortSerializer;
import com.firefly.utils.json.serializer.StringArraySerializer;
import com.firefly.utils.json.serializer.StringSerializer;
import com.firefly.utils.json.serializer.StringValueSerializer;
import com.firefly.utils.json.serializer.TimestampSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class SerialStateMachine {
    private static final IdentityHashMap<Class<?>, Serializer> SERIAL_MAP = new IdentityHashMap();
    private static final Lock lock = new ReentrantLock();
    private static final Serializer MAP = new MapSerializer();
    private static final Serializer COLLECTION = new CollectionSerializer();
    private static final Serializer ARRAY = new ArraySerializer();
    private static final DynamicObjectSerializer DYNAMIC = new DynamicObjectSerializer();
    private static final StringValueSerializer STRING_VALUE = new StringValueSerializer();
    private static final TimestampSerializer TIMESTAMP = new TimestampSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializer getSerializer(Class<?> clazz, DateFormat dateFormat) {
        lock.lock();
        try {
            Serializer ret = SERIAL_MAP.get(clazz);
            if (dateFormat != null && (clazz == java.util.Date.class || java.util.Date.class.isAssignableFrom(clazz))) {
                switch (dateFormat.type()) {
                    case DATE_PATTERN_STRING: {
                        ret = new DateSerializer(dateFormat.value());
                        break;
                    }
                    case TIMESTAMP: {
                        ret = TIMESTAMP;
                        break;
                    }
                }
            } else if (ret == null) {
                ret = clazz.isEnum() ? new EnumSerializer(clazz) : (Map.class.isAssignableFrom(clazz) ? MAP : (Collection.class.isAssignableFrom(clazz) ? COLLECTION : (clazz.isArray() ? ARRAY : (clazz.equals(Object.class) ? DYNAMIC : (clazz.isAnnotationPresent(CircularReferenceCheck.class) ? new ObjectSerializer() : new ObjectNoCheckSerializer())))));
                SERIAL_MAP.put(clazz, ret);
                if (ret instanceof ObjectNoCheckSerializer) {
                    ((ObjectNoCheckSerializer)ret).init(clazz);
                } else if (ret instanceof ObjectSerializer) {
                    ((ObjectSerializer)ret).init(clazz);
                }
            }
            Serializer serializer = ret;
            return serializer;
        }
        finally {
            lock.unlock();
        }
    }

    public static void toJson(Object obj, JsonWriter writer) throws IOException {
        if (obj == null) {
            writer.writeNull();
            return;
        }
        Class<?> clazz = obj.getClass();
        Serializer serializer = SerialStateMachine.getSerializer(clazz, null);
        serializer.convertTo(writer, obj);
    }

    static {
        SERIAL_MAP.put(Long.TYPE, new LongSerializer());
        SERIAL_MAP.put(Integer.TYPE, new IntSerializer());
        SERIAL_MAP.put(Character.TYPE, new CharacterSerializer());
        SERIAL_MAP.put(Short.TYPE, new ShortSerializer());
        SERIAL_MAP.put(Byte.TYPE, new ByteSerializer());
        SERIAL_MAP.put(Boolean.TYPE, new BoolSerializer());
        SERIAL_MAP.put(String.class, new StringSerializer());
        SERIAL_MAP.put(java.util.Date.class, new DateSerializer());
        SERIAL_MAP.put(Double.TYPE, STRING_VALUE);
        SERIAL_MAP.put(long[].class, new LongArraySerializer(true));
        SERIAL_MAP.put(int[].class, new IntegerArraySerializer(true));
        SERIAL_MAP.put(short[].class, new ShortArraySerializer(true));
        SERIAL_MAP.put(boolean[].class, new BooleanArraySerializer(true));
        SERIAL_MAP.put(String[].class, new StringArraySerializer());
        SERIAL_MAP.put(byte[].class, new ByteArraySerializer());
        SERIAL_MAP.put(char[].class, new CharArraySerializer());
        SERIAL_MAP.put(Long.class, SERIAL_MAP.get(Long.TYPE));
        SERIAL_MAP.put(Integer.class, SERIAL_MAP.get(Integer.TYPE));
        SERIAL_MAP.put(Character.class, SERIAL_MAP.get(Character.TYPE));
        SERIAL_MAP.put(Short.class, SERIAL_MAP.get(Short.TYPE));
        SERIAL_MAP.put(Byte.class, SERIAL_MAP.get(Byte.TYPE));
        SERIAL_MAP.put(Boolean.class, SERIAL_MAP.get(Boolean.TYPE));
        SERIAL_MAP.put(Long[].class, new LongArraySerializer(false));
        SERIAL_MAP.put(Integer[].class, new IntegerArraySerializer(false));
        SERIAL_MAP.put(Short[].class, new ShortArraySerializer(false));
        SERIAL_MAP.put(Boolean[].class, new BooleanArraySerializer(false));
        SERIAL_MAP.put(StringBuilder.class, SERIAL_MAP.get(String.class));
        SERIAL_MAP.put(StringBuffer.class, SERIAL_MAP.get(String.class));
        SERIAL_MAP.put(Date.class, SERIAL_MAP.get(java.util.Date.class));
        SERIAL_MAP.put(Time.class, SERIAL_MAP.get(java.util.Date.class));
        SERIAL_MAP.put(Timestamp.class, SERIAL_MAP.get(java.util.Date.class));
        SERIAL_MAP.put(Double.class, STRING_VALUE);
        SERIAL_MAP.put(Float.TYPE, STRING_VALUE);
        SERIAL_MAP.put(Float.class, STRING_VALUE);
        SERIAL_MAP.put(AtomicInteger.class, STRING_VALUE);
        SERIAL_MAP.put(AtomicLong.class, STRING_VALUE);
        SERIAL_MAP.put(BigDecimal.class, STRING_VALUE);
        SERIAL_MAP.put(BigInteger.class, STRING_VALUE);
        SERIAL_MAP.put(AtomicBoolean.class, STRING_VALUE);
    }
}

