/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.serializer;

import com.firefly.utils.json.JsonStringSymbol;
import com.firefly.utils.json.JsonWriter;
import com.firefly.utils.json.Serializer;
import com.firefly.utils.json.serializer.SerialStateMachine;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapSerializer
implements Serializer {
    @Override
    public void convertTo(JsonWriter writer, Object obj) throws IOException {
        Map map = (Map)obj;
        Set entrySet = map.entrySet();
        if (entrySet.size() == 0) {
            writer.write(JsonStringSymbol.EMPTY_ARRAY);
            return;
        }
        writer.append('{');
        Iterator it = entrySet.iterator();
        while (true) {
            Map.Entry entry = it.next();
            writer.write("\"" + entry.getKey() + "\":");
            SerialStateMachine.toJson(entry.getValue(), writer);
            if (!it.hasNext()) {
                writer.append('}');
                return;
            }
            writer.append(',');
        }
    }
}

