/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.serializer;

import com.firefly.utils.json.JsonStringSymbol;
import com.firefly.utils.json.JsonWriter;
import com.firefly.utils.json.Serializer;
import com.firefly.utils.json.serializer.SerialStateMachine;
import java.io.IOException;

public class ArraySerializer
implements Serializer {
    @Override
    public void convertTo(JsonWriter writer, Object obj) throws IOException {
        Object[] objArray = (Object[])obj;
        int iMax = objArray.length - 1;
        if (iMax == -1) {
            writer.write(JsonStringSymbol.EMPTY_ARRAY);
            return;
        }
        writer.append('[');
        int i = 0;
        while (true) {
            SerialStateMachine.toJson(objArray[i], writer);
            if (i == iMax) {
                writer.append(']');
                return;
            }
            writer.append(',');
            ++i;
        }
    }
}

