/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.parser;

import com.firefly.utils.collection.IdentityHashMap;
import com.firefly.utils.json.JsonReader;
import com.firefly.utils.json.Parser;
import com.firefly.utils.json.annotation.DateFormat;
import com.firefly.utils.json.exception.JsonException;
import com.firefly.utils.json.parser.ArrayParser;
import com.firefly.utils.json.parser.BigDecimalParser;
import com.firefly.utils.json.parser.BigIntegerParser;
import com.firefly.utils.json.parser.BooleanParser;
import com.firefly.utils.json.parser.ByteArrayParser;
import com.firefly.utils.json.parser.CharArrayParser;
import com.firefly.utils.json.parser.CharacterParser;
import com.firefly.utils.json.parser.DateParser;
import com.firefly.utils.json.parser.DoubleParser;
import com.firefly.utils.json.parser.EnumParser;
import com.firefly.utils.json.parser.FloatParser;
import com.firefly.utils.json.parser.IntParser;
import com.firefly.utils.json.parser.LongParser;
import com.firefly.utils.json.parser.ObjectParser;
import com.firefly.utils.json.parser.ShortParser;
import com.firefly.utils.json.parser.StringParser;
import com.firefly.utils.json.parser.TimestampParser;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ParserStateMachine {
    private static final IdentityHashMap<Class<?>, Parser> PARSER_MAP = new IdentityHashMap();
    private static final Lock lock = new ReentrantLock();
    private static final TimestampParser TIMESTAMP = new TimestampParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parser getParser(Class<?> clazz, DateFormat dateFormat) {
        lock.lock();
        try {
            Parser ret = PARSER_MAP.get(clazz);
            if (dateFormat != null && clazz == Date.class) {
                switch (dateFormat.type()) {
                    case DATE_PATTERN_STRING: {
                        ret = new DateParser(dateFormat.value());
                        break;
                    }
                    case TIMESTAMP: {
                        ret = TIMESTAMP;
                        break;
                    }
                }
            } else if (ret == null) {
                if (clazz.isEnum()) {
                    ret = new EnumParser(clazz);
                    PARSER_MAP.put(clazz, ret);
                } else {
                    if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
                        throw new JsonException("not support type " + clazz);
                    }
                    if (clazz.isArray()) {
                        Class<?> elementClass = clazz.getComponentType();
                        ret = new ArrayParser(elementClass);
                        PARSER_MAP.put(clazz, ret);
                    } else {
                        ret = new ObjectParser();
                        PARSER_MAP.put(clazz, ret);
                        ((ObjectParser)ret).init(clazz);
                    }
                }
            }
            Parser parser = ret;
            return parser;
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> T toObject(JsonReader reader, Class<?> clazz) throws IOException {
        Parser parser = ParserStateMachine.getParser(clazz, null);
        return (T)parser.convertTo(reader, clazz);
    }

    static {
        PARSER_MAP.put(Integer.TYPE, new IntParser());
        PARSER_MAP.put(Long.TYPE, new LongParser());
        PARSER_MAP.put(Short.TYPE, new ShortParser());
        PARSER_MAP.put(Float.TYPE, new FloatParser());
        PARSER_MAP.put(Double.TYPE, new DoubleParser());
        PARSER_MAP.put(Boolean.TYPE, new BooleanParser());
        PARSER_MAP.put(Character.TYPE, new CharacterParser());
        PARSER_MAP.put(Integer.class, PARSER_MAP.get(Integer.TYPE));
        PARSER_MAP.put(Long.class, PARSER_MAP.get(Long.TYPE));
        PARSER_MAP.put(Short.class, PARSER_MAP.get(Short.TYPE));
        PARSER_MAP.put(Float.class, PARSER_MAP.get(Float.TYPE));
        PARSER_MAP.put(Double.class, PARSER_MAP.get(Double.TYPE));
        PARSER_MAP.put(Boolean.class, PARSER_MAP.get(Boolean.TYPE));
        PARSER_MAP.put(Character.class, PARSER_MAP.get(Character.TYPE));
        PARSER_MAP.put(BigDecimal.class, new BigDecimalParser());
        PARSER_MAP.put(BigInteger.class, new BigIntegerParser());
        PARSER_MAP.put(String.class, new StringParser());
        PARSER_MAP.put(Date.class, new DateParser());
        PARSER_MAP.put(int[].class, new ArrayParser(Integer.TYPE));
        PARSER_MAP.put(long[].class, new ArrayParser(Long.TYPE));
        PARSER_MAP.put(short[].class, new ArrayParser(Short.TYPE));
        PARSER_MAP.put(float[].class, new ArrayParser(Float.TYPE));
        PARSER_MAP.put(double[].class, new ArrayParser(Double.TYPE));
        PARSER_MAP.put(boolean[].class, new ArrayParser(Boolean.TYPE));
        PARSER_MAP.put(byte[].class, new ByteArrayParser());
        PARSER_MAP.put(char[].class, new CharArrayParser());
        PARSER_MAP.put(Integer[].class, new ArrayParser(Integer.class));
        PARSER_MAP.put(Long[].class, new ArrayParser(Long.class));
        PARSER_MAP.put(Short[].class, new ArrayParser(Short.class));
        PARSER_MAP.put(Float[].class, new ArrayParser(Float.class));
        PARSER_MAP.put(Double[].class, new ArrayParser(Double.class));
        PARSER_MAP.put(Boolean[].class, new ArrayParser(Boolean.class));
        PARSER_MAP.put(String[].class, new ArrayParser(String.class));
    }
}

