/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.parser;

import com.firefly.utils.json.JsonReader;
import com.firefly.utils.json.Parser;
import com.firefly.utils.json.compiler.DecodeCompiler;
import com.firefly.utils.json.exception.JsonException;
import com.firefly.utils.json.support.ParserMetaInfo;
import java.util.HashMap;
import java.util.Map;

public class ObjectParser
implements Parser {
    private ParserMetaInfo[] parserMetaInfos;
    private int max;
    private Map<String, ParserMetaInfo> map;
    private boolean useMap;

    public void init(Class<?> clazz) {
        this.parserMetaInfos = DecodeCompiler.compile(clazz);
        this.max = this.parserMetaInfos.length - 1;
        if (this.max >= 8) {
            this.map = new HashMap<String, ParserMetaInfo>();
            for (ParserMetaInfo parserMetaInfo : this.parserMetaInfos) {
                this.map.put(parserMetaInfo.getPropertyNameString(), parserMetaInfo);
            }
            this.useMap = true;
        }
    }

    @Override
    public Object convertTo(JsonReader reader, Class<?> clazz) {
        char c;
        if (reader.isNull()) {
            return null;
        }
        if (!reader.isObject()) {
            throw new JsonException("json string is not object format");
        }
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (reader.isEmptyObject()) {
            return obj;
        }
        int i = 0;
        while (true) {
            ParserMetaInfo parser = this.parserMetaInfos[i];
            char[] field = reader.readField(parser.getPropertyName());
            if (!reader.isColon()) {
                throw new JsonException("missing ':'");
            }
            if (field == null) {
                parser.invoke(obj, reader);
            } else {
                ParserMetaInfo np = this.find(field);
                if (np != null) {
                    np.invoke(obj, reader);
                } else {
                    reader.skipValue();
                }
            }
            if (i == this.max) break;
            char ch = reader.readAndSkipBlank();
            if (ch == '}') {
                return obj;
            }
            if (ch != ',') {
                throw new JsonException("missing ','");
            }
            ++i;
        }
        char ch = reader.readAndSkipBlank();
        if (ch == '}') {
            return obj;
        }
        if (ch != ',') {
            throw new JsonException("json string is not object format");
        }
        do {
            char[] field = reader.readChars();
            if (!reader.isColon()) {
                throw new JsonException("missing ':'");
            }
            ParserMetaInfo np = this.find(field);
            if (np != null) {
                np.invoke(obj, reader);
            } else {
                reader.skipValue();
            }
            c = reader.readAndSkipBlank();
            if (c != '}') continue;
            return obj;
        } while (c == ',');
        throw new JsonException("missing ','");
    }

    private ParserMetaInfo find(char[] field) {
        if (this.useMap) {
            return this.map.get(new String(field));
        }
        for (ParserMetaInfo parserMetaInfo : this.parserMetaInfos) {
            if (!parserMetaInfo.equals(field)) continue;
            return parserMetaInfo;
        }
        return null;
    }
}

