/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.parser;

import com.firefly.utils.json.JsonReader;
import com.firefly.utils.json.exception.JsonException;
import com.firefly.utils.json.parser.ComplexTypeParser;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;

public class MapParser
extends ComplexTypeParser {
    public MapParser(Type elementType) {
        super(elementType);
    }

    @Override
    public Object convertTo(JsonReader reader, Class<?> clazz) throws IOException {
        char ch;
        if (reader.isNull()) {
            return null;
        }
        if (!reader.isObject()) {
            throw new JsonException("json string is not object format");
        }
        Map obj = null;
        try {
            obj = (Map)clazz.newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (reader.isEmptyObject()) {
            return obj;
        }
        do {
            String key = reader.readString();
            if (!reader.isColon()) {
                throw new JsonException("missing ':'");
            }
            obj.put(key, this.elementMetaInfo.getValue(reader));
            ch = reader.readAndSkipBlank();
            if (ch != '}') continue;
            return obj;
        } while (ch == ',');
        throw new JsonException("missing ','");
    }
}

