/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.parser;

import com.firefly.utils.json.JsonArray;
import com.firefly.utils.json.JsonObject;
import com.firefly.utils.json.JsonReader;
import com.firefly.utils.json.exception.JsonException;
import java.io.IOException;

public abstract class GeneralJSONObjectStateMacine {
    public static JsonObject toJsonObject(JsonReader reader) throws IOException {
        if (!reader.isObject()) {
            throw new JsonException("It is not a JSON object, the position is " + reader.position());
        }
        JsonObject map = new JsonObject();
        if (reader.isEmptyObject()) {
            return map;
        }
        block9: while (true) {
            char[] field = reader.readChars();
            if (!reader.isColon()) {
                throw new JsonException("The error occur, near by the key \"" + String.valueOf(field) + "\", the position is " + reader.position());
            }
            char ch = reader.readAndSkipBlank();
            reader.decreasePosition();
            switch (ch) {
                case '{': {
                    map.put(String.valueOf(field), GeneralJSONObjectStateMacine.toJsonObject(reader));
                    break;
                }
                case '[': {
                    map.put(String.valueOf(field), GeneralJSONObjectStateMacine.toJsonArray(reader));
                    break;
                }
                case '\"': {
                    map.put(String.valueOf(field), reader.readString());
                    break;
                }
                default: {
                    map.put(String.valueOf(field), reader.readValueAsString());
                }
            }
            char fieldEndCh = reader.readAndSkipBlank();
            switch (fieldEndCh) {
                case '}': {
                    break block9;
                }
                case ',': {
                    break;
                }
                default: {
                    throw new JsonException("The error is at position " + reader.position());
                }
            }
        }
        return map;
    }

    public static JsonArray toJsonArray(JsonReader reader) throws IOException {
        if (!reader.isArray()) {
            throw new JsonException("It is not a JSON array, the position is " + reader.position());
        }
        JsonArray array = new JsonArray();
        if (reader.isEmptyArray()) {
            return array;
        }
        block9: while (true) {
            char ch = reader.readAndSkipBlank();
            reader.decreasePosition();
            switch (ch) {
                case '{': {
                    array.add(GeneralJSONObjectStateMacine.toJsonObject(reader));
                    break;
                }
                case '[': {
                    array.add(GeneralJSONObjectStateMacine.toJsonArray(reader));
                    break;
                }
                case '\"': {
                    array.add(reader.readString());
                    break;
                }
                default: {
                    array.add(reader.readValueAsString());
                }
            }
            char fieldEndCh = reader.readAndSkipBlank();
            switch (fieldEndCh) {
                case ']': {
                    break block9;
                }
                case ',': {
                    break;
                }
                default: {
                    throw new JsonException("The error is at position " + reader.position());
                }
            }
        }
        return array;
    }
}

