/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.parser;

import com.firefly.utils.json.JsonReader;
import com.firefly.utils.json.exception.JsonException;
import com.firefly.utils.json.parser.ComplexTypeParser;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;

public class CollectionParser
extends ComplexTypeParser {
    public CollectionParser(Type elementType) {
        super(elementType);
    }

    @Override
    public Object convertTo(JsonReader reader, Class<?> clazz) throws IOException {
        char ch;
        if (reader.isNull()) {
            return null;
        }
        if (!reader.isArray()) {
            throw new JsonException("json string is not array format");
        }
        Collection obj = null;
        try {
            obj = (Collection)clazz.newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (reader.isEmptyArray()) {
            return obj;
        }
        do {
            obj.add(this.elementMetaInfo.getValue(reader));
            ch = reader.readAndSkipBlank();
            if (ch != ']') continue;
            return obj;
        } while (ch == ',');
        throw new JsonException("missing ','");
    }
}

