/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.parser;

import com.firefly.utils.ReflectUtils;
import com.firefly.utils.json.JsonReader;
import com.firefly.utils.json.Parser;
import com.firefly.utils.json.exception.JsonException;
import com.firefly.utils.json.parser.ParserStateMachine;
import com.firefly.utils.json.support.ParserMetaInfo;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class ArrayParser
implements Parser {
    private ParserMetaInfo elementMetaInfo = new ParserMetaInfo();

    public ArrayParser(Class<?> clazz) {
        this.elementMetaInfo.setType(clazz);
        this.elementMetaInfo.setParser(ParserStateMachine.getParser(clazz, null));
    }

    @Override
    public Object convertTo(JsonReader reader, Class<?> clazz) throws IOException {
        char ch;
        if (reader.isNull()) {
            return null;
        }
        if (!reader.isArray()) {
            throw new JsonException("json string is not array format");
        }
        if (reader.isEmptyArray()) {
            return Array.newInstance(this.elementMetaInfo.getType(), 0);
        }
        ArrayList<Object> obj = new ArrayList<Object>();
        do {
            obj.add(this.elementMetaInfo.getValue(reader));
            ch = reader.readAndSkipBlank();
            if (ch != ']') continue;
            return this.copyOf(obj);
        } while (ch == ',');
        throw new JsonException("missing ','");
    }

    public Object copyOf(List<Object> list) {
        Object ret = Array.newInstance(this.elementMetaInfo.getType(), list.size());
        for (int i = 0; i < list.size(); ++i) {
            try {
                ReflectUtils.arraySet(ret, i, list.get(i));
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return ret;
    }
}

