/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.io;

import com.firefly.utils.json.io.AbstractJsonStringWriter;
import com.firefly.utils.json.io.IOUtils;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class JsonStringWriter
extends AbstractJsonStringWriter {
    public static Set<Character> SPECIAL_CHARACTER;
    private Deque<Object> deque = new LinkedList<Object>();

    public static String escapeSpecialCharacter(char ch) {
        if (SPECIAL_CHARACTER.contains(Character.valueOf(ch))) {
            String hexStr = Integer.toHexString(ch);
            String padding = "";
            for (int j = hexStr.length(); j < 4; ++j) {
                padding = padding + "0";
            }
            return "\\u" + padding + hexStr;
        }
        return null;
    }

    @Override
    public void pushRef(Object obj) {
        this.deque.addFirst(obj);
    }

    @Override
    public boolean existRef(Object obj) {
        return this.deque.contains(obj);
    }

    @Override
    public void popRef() {
        this.deque.removeFirst();
    }

    private void write(char ch, boolean needExpand) {
        if (needExpand) {
            this.write(ch);
        } else {
            this.buf[this.count++] = ch;
        }
    }

    private void writeJsonString0(String value) {
        boolean needExpand = false;
        this.buf[this.count++] = 34;
        block10: for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\b': {
                    this.write('\\', needExpand);
                    this.write('b', needExpand);
                    continue block10;
                }
                case '\n': {
                    this.write('\\', needExpand);
                    this.write('n', needExpand);
                    continue block10;
                }
                case '\r': {
                    this.write('\\', needExpand);
                    this.write('r', needExpand);
                    continue block10;
                }
                case '\f': {
                    this.write('\\', needExpand);
                    this.write('f', needExpand);
                    continue block10;
                }
                case '\\': {
                    this.write('\\', needExpand);
                    this.write('\\', needExpand);
                    continue block10;
                }
                case '/': {
                    this.write('\\', needExpand);
                    this.write('/', needExpand);
                    continue block10;
                }
                case '\"': {
                    this.write('\\', needExpand);
                    this.write('\"', needExpand);
                    continue block10;
                }
                case '\t': {
                    this.write('\\', needExpand);
                    this.write('t', needExpand);
                    continue block10;
                }
                default: {
                    String hexStr = JsonStringWriter.escapeSpecialCharacter(ch);
                    if (hexStr == null) {
                        this.write(ch, needExpand);
                        continue block10;
                    }
                    needExpand = true;
                    this.write(hexStr);
                }
            }
        }
        this.write('\"', needExpand);
    }

    @Override
    public void writeStringWithQuote(String value) {
        int newcount = this.count + value.length() * 2 + 2;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.writeJsonString0(value);
    }

    @Override
    public void writeStringArray(String[] array) {
        int arrayLen = array.length;
        if (arrayLen == 0) {
            this.buf[this.count++] = 91;
            this.buf[this.count++] = 93;
            return;
        }
        int iMax = arrayLen - 1;
        int totalSize = 2;
        for (int i = 0; i < arrayLen; ++i) {
            totalSize += array[i].length() * 2 + 2 + 1;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count++] = 91;
        int i = 0;
        while (true) {
            this.writeJsonString0(array[i]);
            if (i == iMax) {
                this.buf[this.count++] = 93;
                return;
            }
            this.buf[this.count++] = 44;
            ++i;
        }
    }

    @Override
    public void writeIntArray(int[] array) {
        int arrayLen = array.length;
        if (arrayLen == 0) {
            this.buf[this.count++] = 91;
            this.buf[this.count++] = 93;
            return;
        }
        int iMax = arrayLen - 1;
        int elementMaxLen = MIN_INT_VALUE.length;
        int newcount = this.count + (elementMaxLen + 1) * arrayLen + 2 - 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count++] = 91;
        int i = 0;
        while (true) {
            int val;
            if ((val = array[i]) == Integer.MIN_VALUE) {
                System.arraycopy(MIN_INT_VALUE, 0, this.buf, this.count, elementMaxLen);
                this.count += elementMaxLen;
            } else {
                this.count += val < 0 ? IOUtils.stringSize(-val) + 1 : IOUtils.stringSize(val);
                IOUtils.getChars(val, this.count, this.buf);
            }
            if (i == iMax) {
                this.buf[this.count++] = 93;
                return;
            }
            this.buf[this.count++] = 44;
            ++i;
        }
    }

    @Override
    public void writeIntArray(Integer[] array) {
        int arrayLen = array.length;
        if (arrayLen == 0) {
            this.buf[this.count++] = 91;
            this.buf[this.count++] = 93;
            return;
        }
        int iMax = arrayLen - 1;
        int elementMaxLen = MIN_INT_VALUE.length;
        int newcount = this.count + (elementMaxLen + 1) * arrayLen + 2 - 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count++] = 91;
        int i = 0;
        while (true) {
            int val;
            if ((val = array[i].intValue()) == Integer.MIN_VALUE) {
                System.arraycopy(MIN_INT_VALUE, 0, this.buf, this.count, elementMaxLen);
                this.count += elementMaxLen;
            } else {
                this.count += val < 0 ? IOUtils.stringSize(-val) + 1 : IOUtils.stringSize(val);
                IOUtils.getChars(val, this.count, this.buf);
            }
            if (i == iMax) {
                this.buf[this.count++] = 93;
                return;
            }
            this.buf[this.count++] = 44;
            ++i;
        }
    }

    @Override
    public void writeShortArray(short[] array) {
        int arrayLen = array.length;
        if (arrayLen == 0) {
            this.buf[this.count++] = 91;
            this.buf[this.count++] = 93;
            return;
        }
        int iMax = arrayLen - 1;
        int elementMaxLen = MIN_INT_VALUE.length;
        int newcount = this.count + (elementMaxLen + 1) * arrayLen + 2 - 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count++] = 91;
        int i = 0;
        while (true) {
            short val;
            if ((val = array[i]) == Integer.MIN_VALUE) {
                System.arraycopy(MIN_INT_VALUE, 0, this.buf, this.count, elementMaxLen);
                this.count += elementMaxLen;
            } else {
                this.count += val < 0 ? IOUtils.stringSize(-val) + 1 : IOUtils.stringSize(val);
                IOUtils.getChars(val, this.count, this.buf);
            }
            if (i == iMax) {
                this.buf[this.count++] = 93;
                return;
            }
            this.buf[this.count++] = 44;
            ++i;
        }
    }

    @Override
    public void writeShortArray(Short[] array) {
        int arrayLen = array.length;
        if (arrayLen == 0) {
            this.buf[this.count++] = 91;
            this.buf[this.count++] = 93;
            return;
        }
        int iMax = arrayLen - 1;
        int elementMaxLen = MIN_INT_VALUE.length;
        int newcount = this.count + (elementMaxLen + 1) * arrayLen + 2 - 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count++] = 91;
        int i = 0;
        while (true) {
            short val;
            if ((val = array[i].shortValue()) == Integer.MIN_VALUE) {
                System.arraycopy(MIN_INT_VALUE, 0, this.buf, this.count, elementMaxLen);
                this.count += elementMaxLen;
            } else {
                this.count += val < 0 ? IOUtils.stringSize(-val) + 1 : IOUtils.stringSize(val);
                IOUtils.getChars(val, this.count, this.buf);
            }
            if (i == iMax) {
                this.buf[this.count++] = 93;
                return;
            }
            this.buf[this.count++] = 44;
            ++i;
        }
    }

    @Override
    public void writeLongArray(long[] array) {
        int arrayLen = array.length;
        if (arrayLen == 0) {
            this.buf[this.count++] = 91;
            this.buf[this.count++] = 93;
            return;
        }
        int iMax = arrayLen - 1;
        int elementMaxLen = MIN_LONG_VALUE.length;
        int newcount = this.count + (elementMaxLen + 1) * arrayLen + 2 - 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count++] = 91;
        int i = 0;
        while (true) {
            long val;
            if ((val = array[i]) == Long.MIN_VALUE) {
                System.arraycopy(MIN_LONG_VALUE, 0, this.buf, this.count, elementMaxLen);
                this.count += elementMaxLen;
            } else {
                this.count += val < 0L ? IOUtils.stringSize(-val) + 1 : IOUtils.stringSize(val);
                IOUtils.getChars(val, this.count, this.buf);
            }
            if (i == iMax) {
                this.buf[this.count++] = 93;
                return;
            }
            this.buf[this.count++] = 44;
            ++i;
        }
    }

    @Override
    public void writeLongArray(Long[] array) {
        int arrayLen = array.length;
        if (arrayLen == 0) {
            this.buf[this.count++] = 91;
            this.buf[this.count++] = 93;
            return;
        }
        int iMax = arrayLen - 1;
        int elementMaxLen = MIN_LONG_VALUE.length;
        int newcount = this.count + (elementMaxLen + 1) * arrayLen + 2 - 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count++] = 91;
        int i = 0;
        while (true) {
            long val;
            if ((val = array[i].longValue()) == Long.MIN_VALUE) {
                System.arraycopy(MIN_LONG_VALUE, 0, this.buf, this.count, elementMaxLen);
                this.count += elementMaxLen;
            } else {
                this.count += val < 0L ? IOUtils.stringSize(-val) + 1 : IOUtils.stringSize(val);
                IOUtils.getChars(val, this.count, this.buf);
            }
            if (i == iMax) {
                this.buf[this.count++] = 93;
                return;
            }
            this.buf[this.count++] = 44;
            ++i;
        }
    }

    @Override
    public void writeBooleanArray(boolean[] array) {
        int arrayLen = array.length;
        if (arrayLen == 0) {
            this.buf[this.count++] = 91;
            this.buf[this.count++] = 93;
            return;
        }
        int iMax = arrayLen - 1;
        int newcount = this.count + 6 * arrayLen + 2 - 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count++] = 91;
        int i = 0;
        while (true) {
            if (array[i]) {
                this.buf[this.count++] = 116;
                this.buf[this.count++] = 114;
                this.buf[this.count++] = 117;
                this.buf[this.count++] = 101;
            } else {
                this.buf[this.count++] = 102;
                this.buf[this.count++] = 97;
                this.buf[this.count++] = 108;
                this.buf[this.count++] = 115;
                this.buf[this.count++] = 101;
            }
            if (i == iMax) {
                this.buf[this.count++] = 93;
                return;
            }
            this.buf[this.count++] = 44;
            ++i;
        }
    }

    @Override
    public void writeBooleanArray(Boolean[] array) {
        int arrayLen = array.length;
        if (arrayLen == 0) {
            this.buf[this.count++] = 91;
            this.buf[this.count++] = 93;
            return;
        }
        int iMax = arrayLen - 1;
        int newcount = this.count + 6 * arrayLen + 2 - 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count++] = 91;
        int i = 0;
        while (true) {
            if (array[i].booleanValue()) {
                this.buf[this.count++] = 116;
                this.buf[this.count++] = 114;
                this.buf[this.count++] = 117;
                this.buf[this.count++] = 101;
            } else {
                this.buf[this.count++] = 102;
                this.buf[this.count++] = 97;
                this.buf[this.count++] = 108;
                this.buf[this.count++] = 115;
                this.buf[this.count++] = 101;
            }
            if (i == iMax) {
                this.buf[this.count++] = 93;
                return;
            }
            this.buf[this.count++] = 44;
            ++i;
        }
    }

    static {
        int i;
        SPECIAL_CHARACTER = new HashSet<Character>();
        for (i = 0; i <= 31; ++i) {
            SPECIAL_CHARACTER.add(Character.valueOf((char)i));
        }
        for (i = 127; i <= 159; ++i) {
            SPECIAL_CHARACTER.add(Character.valueOf((char)i));
        }
        SPECIAL_CHARACTER.add(Character.valueOf('\u00ad'));
        for (i = 1536; i <= 1540; ++i) {
            SPECIAL_CHARACTER.add(Character.valueOf((char)i));
        }
        SPECIAL_CHARACTER.add(Character.valueOf('\u070f'));
        SPECIAL_CHARACTER.add(Character.valueOf('\u17b4'));
        SPECIAL_CHARACTER.add(Character.valueOf('\u17b5'));
        for (i = 8204; i <= 8207; ++i) {
            SPECIAL_CHARACTER.add(Character.valueOf((char)i));
        }
        for (i = 8232; i <= 8239; ++i) {
            SPECIAL_CHARACTER.add(Character.valueOf((char)i));
        }
        for (i = 8288; i <= 8303; ++i) {
            SPECIAL_CHARACTER.add(Character.valueOf((char)i));
        }
        SPECIAL_CHARACTER.add(Character.valueOf('\ufeff'));
        for (i = 65281; i <= 65295; ++i) {
            SPECIAL_CHARACTER.add(Character.valueOf((char)i));
        }
        for (i = 65520; i <= 65535; ++i) {
            SPECIAL_CHARACTER.add(Character.valueOf((char)i));
        }
    }
}

