/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.io;

import com.firefly.utils.VerifyUtils;
import com.firefly.utils.json.JsonReader;
import com.firefly.utils.json.exception.JsonException;
import com.firefly.utils.json.io.JsonStringWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonStringReader
extends JsonReader {
    private char[] chars;
    private int pos = 0;
    private final int limit;
    private int mark = 0;

    public JsonStringReader(String str) {
        this.chars = str.toCharArray();
        this.limit = this.chars.length;
    }

    @Override
    public void increasePosition() {
        ++this.pos;
    }

    @Override
    public void decreasePosition() {
        --this.pos;
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public boolean isEnd() {
        return this.pos >= this.limit;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public boolean isEndFlag(char ch) {
        switch (ch) {
            case ' ': 
            case ',': 
            case ':': 
            case ']': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isString() {
        char c = this.readAndSkipBlank();
        return c == '\"';
    }

    @Override
    public boolean isArray() {
        char c = this.readAndSkipBlank();
        return c == '[';
    }

    @Override
    public boolean isEmptyArray() {
        this.mark(1024);
        char c = this.readAndSkipBlank();
        if (c == ']') {
            return true;
        }
        this.reset();
        return false;
    }

    @Override
    public boolean isObject() {
        char c = this.readAndSkipBlank();
        return c == '{';
    }

    @Override
    public boolean isEmptyObject() {
        this.mark(1024);
        char c = this.readAndSkipBlank();
        if (c == '}') {
            return true;
        }
        this.reset();
        return false;
    }

    @Override
    public boolean isColon() {
        char c = this.readAndSkipBlank();
        return c == ':';
    }

    @Override
    public boolean isComma() {
        char c = this.readAndSkipBlank();
        return c == ',';
    }

    @Override
    public boolean isNull() {
        this.mark(1024);
        char ch = this.readAndSkipBlank();
        if (this.pos + 3 > this.limit) {
            this.reset();
            return false;
        }
        if (ch == 'n' && 117 == this.read() && 108 == this.read() && 108 == this.read()) {
            if (this.pos >= this.limit) {
                return true;
            }
            ch = this.readAndSkipBlank();
            if (this.isEndFlag(ch)) {
                --this.pos;
                return true;
            }
            this.reset();
            return false;
        }
        this.reset();
        return false;
    }

    @Override
    public int read() {
        return this.chars[this.pos++];
    }

    @Override
    public char readAndSkipBlank() {
        char c = (char)this.read();
        if (c > ' ') {
            return c;
        }
        while ((c = (char)this.read()) <= ' ') {
        }
        return c;
    }

    @Override
    public boolean readBoolean() {
        boolean isString;
        boolean ret = false;
        if (this.isNull()) {
            return ret;
        }
        char ch = this.readAndSkipBlank();
        boolean bl = isString = ch == '\"';
        if (isString) {
            ch = this.readAndSkipBlank();
        }
        if (ch == 't' && 114 == this.read() && 117 == this.read() && 101 == this.read()) {
            ret = true;
        } else if (ch == 'f' && 97 == this.read() && 108 == this.read() && 115 == this.read() && 101 == this.read()) {
            ret = false;
        }
        if (isString && (ch = this.readAndSkipBlank()) != '\"') {
            throw new JsonException("read boolean error, the position is " + this.pos);
        }
        return ret;
    }

    @Override
    public int readInt() {
        boolean negative;
        boolean isString;
        int value = 0;
        if (this.isNull()) {
            return value;
        }
        char ch = this.readAndSkipBlank();
        boolean bl = isString = ch == '\"';
        if (isString) {
            ch = this.readAndSkipBlank();
        }
        boolean bl2 = negative = ch == '-';
        if (!negative) {
            if (VerifyUtils.isDigit(ch)) {
                value = (value << 3) + (value << 1) + (ch - 48);
            } else {
                throw new JsonException("read int error, charactor \"" + ch + "\" is not integer, the position is " + this.pos);
            }
        }
        do {
            if (VerifyUtils.isDigit(ch = (char)this.read())) {
                value = (value << 3) + (value << 1) + (ch - 48);
                continue;
            }
            if (isString) {
                if (ch != '\"') continue;
                break;
            }
            if (this.isEndFlag(ch)) {
                --this.pos;
                break;
            }
            throw new JsonException("read int error, charactor \"" + ch + "\" is not integer, the position is " + this.pos);
        } while (this.pos < this.limit);
        return negative ? -value : value;
    }

    @Override
    public long readLong() {
        boolean negative;
        boolean isString;
        long value = 0L;
        if (this.isNull()) {
            return value;
        }
        char ch = this.readAndSkipBlank();
        boolean bl = isString = ch == '\"';
        if (isString) {
            ch = this.readAndSkipBlank();
        }
        boolean bl2 = negative = ch == '-';
        if (!negative) {
            if (VerifyUtils.isDigit(ch)) {
                value = (value << 3) + (value << 1) + (long)(ch - 48);
            } else {
                throw new JsonException("read int error, charactor \"" + ch + "\" is not integer, the position is " + this.pos);
            }
        }
        do {
            if (VerifyUtils.isDigit(ch = (char)this.read())) {
                value = (value << 3) + (value << 1) + (long)(ch - 48);
                continue;
            }
            if (isString) {
                if (ch != '\"') continue;
                break;
            }
            if (this.isEndFlag(ch)) {
                --this.pos;
                break;
            }
            throw new JsonException("read int error, charactor \"" + ch + "\" is not integer, the position is " + this.pos);
        } while (this.pos < this.limit);
        return negative ? -value : value;
    }

    @Override
    public String readValueAsString() {
        int start = this.pos;
        int startBlankLength = 0;
        int endBlankLength = 0;
        boolean hasChar = false;
        while (true) {
            char ch;
            if ((ch = (char)this.read()) <= ' ') {
                if (!hasChar) {
                    ++startBlankLength;
                    continue;
                }
                ++endBlankLength;
                continue;
            }
            if (!hasChar) {
                hasChar = true;
            }
            if (this.isEndFlag(ch)) break;
        }
        --this.pos;
        int end = this.pos - endBlankLength;
        int len = end - (start += startBlankLength);
        return new String(this.chars, start, len);
    }

    @Override
    public BigInteger readBigInteger() {
        int start;
        boolean isString;
        block4: {
            String value = "0";
            if (this.isNull()) {
                return new BigInteger(value);
            }
            char ch = this.readAndSkipBlank();
            boolean bl = isString = ch == '\"';
            if (isString) {
                ch = this.readAndSkipBlank();
            }
            --this.pos;
            start = this.pos;
            while (true) {
                ch = (char)this.read();
                if (isString) {
                    if (ch != '\"') continue;
                    break block4;
                }
                if (this.isEndFlag(ch)) break;
            }
            --this.pos;
        }
        int len = isString ? this.pos - start - 1 : this.pos - start;
        String temp = new String(this.chars, start, len);
        return new BigInteger(temp);
    }

    @Override
    public BigDecimal readBigDecimal() {
        int start;
        boolean isString;
        block4: {
            String value = "0.0";
            if (this.isNull()) {
                return new BigDecimal(value);
            }
            char ch = this.readAndSkipBlank();
            boolean bl = isString = ch == '\"';
            if (isString) {
                ch = this.readAndSkipBlank();
            }
            --this.pos;
            start = this.pos;
            while (true) {
                ch = (char)this.read();
                if (isString) {
                    if (ch != '\"') continue;
                    break block4;
                }
                if (this.isEndFlag(ch)) break;
            }
            --this.pos;
        }
        int len = isString ? this.pos - start - 1 : this.pos - start;
        String temp = new String(this.chars, start, len);
        return new BigDecimal(temp);
    }

    @Override
    public double readDouble() {
        int start;
        boolean isString;
        block4: {
            double value = 0.0;
            if (this.isNull()) {
                return value;
            }
            char ch = this.readAndSkipBlank();
            boolean bl = isString = ch == '\"';
            if (isString) {
                ch = this.readAndSkipBlank();
            }
            --this.pos;
            start = this.pos;
            while (true) {
                ch = (char)this.read();
                if (isString) {
                    if (ch != '\"') continue;
                    break block4;
                }
                if (this.isEndFlag(ch)) break;
            }
            --this.pos;
        }
        int len = isString ? this.pos - start - 1 : this.pos - start;
        String temp = new String(this.chars, start, len);
        return Double.parseDouble(temp);
    }

    @Override
    public float readFloat() {
        int start;
        boolean isString;
        block4: {
            float value = 0.0f;
            if (this.isNull()) {
                return value;
            }
            char ch = this.readAndSkipBlank();
            boolean bl = isString = ch == '\"';
            if (isString) {
                ch = this.readAndSkipBlank();
            }
            --this.pos;
            start = this.pos;
            while (true) {
                ch = (char)this.read();
                if (isString) {
                    if (ch != '\"') continue;
                    break block4;
                }
                if (this.isEndFlag(ch)) break;
            }
            --this.pos;
        }
        int len = isString ? this.pos - start - 1 : this.pos - start;
        String temp = new String(this.chars, start, len);
        return Float.parseFloat(temp);
    }

    @Override
    public char[] readField(char[] chs) {
        char c;
        if (!this.isString()) {
            throw new JsonException("read field error, the position is " + this.pos);
        }
        int cur = this.pos;
        int len = chs.length;
        boolean skip = true;
        int next = this.pos + len;
        if (next < this.limit && this.chars[next] == '\"') {
            for (int i = 0; i < len; ++i) {
                if (chs[i] == this.chars[cur++]) continue;
                skip = false;
                break;
            }
        } else {
            skip = false;
        }
        if (skip) {
            this.pos = cur + 1;
            return null;
        }
        char[] field = null;
        int start = this.pos;
        while ((c = (char)this.read()) != '\"') {
        }
        int fieldLen = this.pos - 1 - start;
        field = new char[fieldLen];
        System.arraycopy(this.chars, start, field, 0, fieldLen);
        return field;
    }

    @Override
    public char[] readChars() {
        char c;
        if (!this.isString()) {
            throw new JsonException("read field error, the position is " + this.pos);
        }
        int start = this.pos;
        while ((c = (char)this.read()) != '\"') {
        }
        int fieldLen = this.pos - 1 - start;
        char[] c2 = new char[fieldLen];
        System.arraycopy(this.chars, start, c2, 0, fieldLen);
        return c2;
    }

    @Override
    public void skipValue() {
        char ch = this.readAndSkipBlank();
        block0 : switch (ch) {
            case '\"': {
                while ((ch = (char)this.read()) != '\"') {
                    if (ch != '\\') continue;
                    ++this.pos;
                }
                break;
            }
            case '[': {
                while (!this.isEmptyArray()) {
                    this.skipValue();
                    ch = this.readAndSkipBlank();
                    if (ch == ']') break block0;
                    if (ch == ',') continue;
                    throw new JsonException("json string array format error, the position is " + this.pos);
                }
                break;
            }
            case '{': {
                while (!this.isEmptyObject()) {
                    this.readChars();
                    if (!this.isColon()) {
                        throw new JsonException("json string object format error, the position is " + this.pos);
                    }
                    this.skipValue();
                    ch = this.readAndSkipBlank();
                    if (ch == '}') break block0;
                    if (ch == ',') continue;
                    throw new JsonException("json string object format error, the position is " + this.pos);
                }
                break;
            }
            default: {
                while (!this.isEndFlag(ch = (char)this.read())) {
                }
                --this.pos;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readString() {
        if (this.isNull()) {
            return null;
        }
        if (!this.isString()) {
            throw new JsonException("read string error, the position is " + this.pos);
        }
        JsonStringWriter writer = new JsonStringWriter();
        String ret = null;
        int cur = this.pos;
        int len = 0;
        while (true) {
            char ch;
            if ((ch = this.chars[cur++]) == '\"') break;
            if (ch != '\\') continue;
            char c0 = this.chars[cur++];
            len = cur - 2 - this.pos;
            writer.write(this.chars, this.pos, len);
            switch (c0) {
                case 'b': {
                    writer.write(8);
                    break;
                }
                case 'n': {
                    writer.write(10);
                    break;
                }
                case 'r': {
                    writer.write(13);
                    break;
                }
                case 'f': {
                    writer.write(12);
                    break;
                }
                case '\\': {
                    writer.write(92);
                    break;
                }
                case '/': {
                    writer.write(47);
                    break;
                }
                case '\"': {
                    writer.write(34);
                    break;
                }
                case 't': {
                    writer.write(9);
                    break;
                }
                case 'u': {
                    char[] controlChars = new char[4];
                    for (int i = 0; i < controlChars.length; ++i) {
                        controlChars[i] = this.chars[cur++];
                    }
                    char tmp = (char)Integer.parseInt(String.valueOf(controlChars), 16);
                    writer.write(tmp);
                }
            }
            this.pos = cur;
        }
        len = cur - this.pos - 1;
        writer.write(this.chars, this.pos, len);
        this.pos = cur;
        try {
            ret = writer.toString();
        }
        finally {
            writer.close();
        }
        return ret;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new JsonException("method not implements!");
    }

    @Override
    public void close() throws IOException {
    }
}

