/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.io;

import com.firefly.utils.json.JsonWriter;
import com.firefly.utils.json.io.IOUtils;
import java.lang.ref.SoftReference;

public abstract class AbstractJsonStringWriter
extends JsonWriter {
    protected char[] buf;
    protected int count;
    protected static final ThreadLocal<SoftReference<char[]>> bufLocal = new ThreadLocal();
    public static final char[] NULL = "null".toCharArray();
    public static final char[] MIN_INT_VALUE = "-2147483648".toCharArray();
    public static final char[] MIN_LONG_VALUE = "-9223372036854775808".toCharArray();
    public static final char[] TRUE_VALUE = "true".toCharArray();
    public static final char[] FALSE_VALUE = "false".toCharArray();

    public AbstractJsonStringWriter() {
        SoftReference<char[]> ref = bufLocal.get();
        if (ref != null) {
            this.buf = ref.get();
            bufLocal.set(null);
        }
        if (this.buf == null) {
            this.buf = new char[1024];
        }
    }

    public AbstractJsonStringWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative initial size: " + initialSize);
        }
        this.buf = new char[initialSize];
    }

    @Override
    public void write(int c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = (char)c;
        this.count = newcount;
    }

    @Override
    public void write(char[] c) {
        this.write(c, 0, c.length);
    }

    @Override
    public void write(char[] c, int off, int len) {
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count = newcount;
    }

    @Override
    public void write(String str) {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(off, off + len, this.buf, this.count);
        this.count = newcount;
    }

    @Override
    public AbstractJsonStringWriter append(CharSequence csq) {
        String str = csq.toString();
        this.write(str, 0, str.length());
        return this;
    }

    @Override
    public AbstractJsonStringWriter append(CharSequence csq, int start, int end) {
        String str = csq.subSequence(start, end).toString();
        this.write(str, 0, str.length());
        return this;
    }

    @Override
    public AbstractJsonStringWriter append(char c) {
        this.write(c);
        return this;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.reset();
        bufLocal.set(new SoftReference<char[]>(this.buf));
    }

    @Override
    public void writeNull() {
        this.write(NULL);
    }

    @Override
    public void writeBoolean(boolean b) {
        if (b) {
            this.write(TRUE_VALUE);
        } else {
            this.write(FALSE_VALUE);
        }
    }

    @Override
    public void writeInt(int i) {
        if (i == Integer.MIN_VALUE) {
            this.write(MIN_INT_VALUE);
            return;
        }
        int size = i < 0 ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount = this.count + size;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        IOUtils.getChars(i, newcount, this.buf);
        this.count = newcount;
    }

    @Override
    public void writeShort(short i) {
        this.writeInt(i);
    }

    @Override
    public void writeByte(byte i) {
        this.writeInt(i);
    }

    @Override
    public void writeLong(long i) {
        if (i == Long.MIN_VALUE) {
            this.write(MIN_LONG_VALUE);
            return;
        }
        int size = i < 0L ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount = this.count + size;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        IOUtils.getChars(i, newcount, this.buf);
        this.count = newcount;
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    protected void expandCapacity(int minimumCapacity) {
        int newCapacity = this.buf.length * 3 / 2 + 1;
        if (newCapacity < minimumCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.buf, 0, newValue, 0, this.count);
        this.buf = newValue;
    }
}

