/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.compiler;

import com.firefly.utils.json.annotation.DateFormat;
import com.firefly.utils.json.annotation.Transient;
import com.firefly.utils.json.serializer.SerialStateMachine;
import com.firefly.utils.json.support.FieldInvoke;
import com.firefly.utils.json.support.MethodInvoke;
import com.firefly.utils.json.support.SerializerMetaInfo;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.TreeSet;

public class EncodeCompiler {
    private static final SerializerMetaInfo[] EMPTY_ARRAY = new SerializerMetaInfo[0];

    public static SerializerMetaInfo[] compile(Class<?> clazz) {
        SerializerMetaInfo[] serializerMetaInfos = null;
        TreeSet<SerializerMetaInfo> fieldSet = new TreeSet<SerializerMetaInfo>();
        for (Method method : clazz.getMethods()) {
            method.setAccessible(true);
            String methodName = method.getName();
            if (method.getDeclaringClass().equals(Object.class) || method.getName().length() < 3 || Modifier.isStatic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers()) || !method.getName().startsWith("get") && !method.getName().startsWith("is") || method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE || method.isAnnotationPresent(Transient.class)) continue;
            String propertyName = null;
            if (methodName.charAt(0) == 'g') {
                if (methodName.length() < 4) continue;
                propertyName = Character.isUpperCase(methodName.charAt(3)) ? Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4) : methodName.substring(3);
            } else {
                if (methodName.length() < 3) continue;
                propertyName = Character.isUpperCase(methodName.charAt(2)) ? Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3) : methodName.substring(2);
            }
            Field field = null;
            try {
                field = clazz.getDeclaredField(propertyName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (field != null && (Modifier.isTransient(field.getModifiers()) || field.isAnnotationPresent(Transient.class))) continue;
            Class<?> fieldClazz = method.getReturnType();
            SerializerMetaInfo fieldMetaInfo = new SerializerMetaInfo();
            fieldMetaInfo.setPropertyName(propertyName, false);
            fieldMetaInfo.setPropertyInvoke(new MethodInvoke(method));
            DateFormat d = null;
            if (field != null) {
                d = field.getAnnotation(DateFormat.class);
            }
            if (d == null) {
                d = method.getAnnotation(DateFormat.class);
            }
            fieldMetaInfo.setSerializer(SerialStateMachine.getSerializer(fieldClazz, d));
            fieldSet.add(fieldMetaInfo);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (Modifier.isTransient(((Field)accessibleObject).getModifiers()) || accessibleObject.isAnnotationPresent(Transient.class) || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            ((Field)accessibleObject).setAccessible(true);
            SerializerMetaInfo fieldMetaInfo = new SerializerMetaInfo();
            fieldMetaInfo.setPropertyName(((Field)accessibleObject).getName(), false);
            fieldMetaInfo.setPropertyInvoke(new FieldInvoke((Field)accessibleObject));
            fieldMetaInfo.setSerializer(SerialStateMachine.getSerializer(((Field)accessibleObject).getType(), ((Field)accessibleObject).getAnnotation(DateFormat.class)));
            fieldSet.add(fieldMetaInfo);
        }
        serializerMetaInfos = fieldSet.toArray(EMPTY_ARRAY);
        if (serializerMetaInfos.length > 0) {
            serializerMetaInfos[0].setPropertyName(serializerMetaInfos[0].getPropertyNameString(), true);
        }
        return serializerMetaInfos;
    }
}

