/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.json.compiler;

import com.firefly.utils.json.annotation.DateFormat;
import com.firefly.utils.json.annotation.Transient;
import com.firefly.utils.json.exception.JsonException;
import com.firefly.utils.json.parser.CollectionParser;
import com.firefly.utils.json.parser.ComplexTypeParser;
import com.firefly.utils.json.parser.MapParser;
import com.firefly.utils.json.parser.ParserStateMachine;
import com.firefly.utils.json.support.FieldInvoke;
import com.firefly.utils.json.support.MethodInvoke;
import com.firefly.utils.json.support.ParserMetaInfo;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;

public class DecodeCompiler {
    private static final ParserMetaInfo[] EMPTY_ARRAY = new ParserMetaInfo[0];

    public static ParserMetaInfo[] compile(Class<?> clazz) {
        ParserMetaInfo[] parserMetaInfos = null;
        TreeSet<ParserMetaInfo> fieldSet = new TreeSet<ParserMetaInfo>();
        for (Method method : clazz.getMethods()) {
            Type[] types2;
            ParameterizedType paramType;
            Type[] types;
            method.setAccessible(true);
            String methodName = method.getName();
            if (method.getDeclaringClass().equals(Object.class) || method.getName().length() < 4 || !method.getName().startsWith("set") || method.getParameterTypes().length != 1 || Modifier.isStatic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers()) || method.isAnnotationPresent(Transient.class) || methodName.length() < 4) continue;
            String propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            Field field = null;
            try {
                field = clazz.getDeclaredField(propertyName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (field != null && (Modifier.isTransient(field.getModifiers()) || field.isAnnotationPresent(Transient.class))) continue;
            ParserMetaInfo parserMetaInfo = new ParserMetaInfo();
            parserMetaInfo.setPropertyNameString(propertyName);
            parserMetaInfo.setPropertyInvoke(new MethodInvoke(method));
            Class<?> type = method.getParameterTypes()[0];
            if (Collection.class.isAssignableFrom(type)) {
                types = method.getGenericParameterTypes();
                if (types.length != 1 || !(types[0] instanceof ParameterizedType)) {
                    throw new JsonException("not support the " + method);
                }
                paramType = (ParameterizedType)types[0];
                types2 = paramType.getActualTypeArguments();
                if (types2.length != 1) {
                    throw new JsonException("not support the " + method);
                }
                Type elementType = types2[0];
                parserMetaInfo.setType(ComplexTypeParser.getImplClass(type));
                parserMetaInfo.setParser(new CollectionParser(elementType));
            } else if (Map.class.isAssignableFrom(type)) {
                types = method.getGenericParameterTypes();
                if (types.length != 1 || !(types[0] instanceof ParameterizedType)) {
                    throw new JsonException("not support the " + method);
                }
                paramType = (ParameterizedType)types[0];
                types2 = paramType.getActualTypeArguments();
                if (types2.length != 2) {
                    throw new JsonException("not support the " + method);
                }
                Type key = types2[0];
                if (!(key instanceof Class) || key != String.class) {
                    throw new JsonException("not support the " + method);
                }
                Type elementType = types2[1];
                parserMetaInfo.setType(ComplexTypeParser.getImplClass(type));
                parserMetaInfo.setParser(new MapParser(elementType));
            } else {
                DateFormat d = null;
                if (field != null) {
                    d = field.getAnnotation(DateFormat.class);
                }
                if (d == null) {
                    d = method.getAnnotation(DateFormat.class);
                }
                parserMetaInfo.setType(type);
                parserMetaInfo.setParser(ParserStateMachine.getParser(type, d));
            }
            fieldSet.add(parserMetaInfo);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            Type[] types2;
            ParameterizedType paramType;
            Type fieldType;
            if (Modifier.isTransient(((Field)accessibleObject).getModifiers()) || accessibleObject.isAnnotationPresent(Transient.class) || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            ((Field)accessibleObject).setAccessible(true);
            ParserMetaInfo parserMetaInfo = new ParserMetaInfo();
            parserMetaInfo.setPropertyNameString(((Field)accessibleObject).getName());
            parserMetaInfo.setPropertyInvoke(new FieldInvoke((Field)accessibleObject));
            Class<?> type = ((Field)accessibleObject).getType();
            if (Collection.class.isAssignableFrom(type)) {
                fieldType = ((Field)accessibleObject).getGenericType();
                if (!(fieldType instanceof ParameterizedType)) {
                    throw new JsonException("not support the " + accessibleObject);
                }
                paramType = (ParameterizedType)fieldType;
                types2 = paramType.getActualTypeArguments();
                if (types2.length != 1) {
                    throw new JsonException("not support the " + accessibleObject);
                }
                Type elementType = types2[0];
                parserMetaInfo.setType(ComplexTypeParser.getImplClass(type));
                parserMetaInfo.setParser(new CollectionParser(elementType));
            } else if (Map.class.isAssignableFrom(type)) {
                fieldType = ((Field)accessibleObject).getGenericType();
                if (!(fieldType instanceof ParameterizedType)) {
                    throw new JsonException("not support the " + accessibleObject);
                }
                paramType = (ParameterizedType)fieldType;
                types2 = paramType.getActualTypeArguments();
                if (types2.length != 2) {
                    throw new JsonException("not support the " + accessibleObject);
                }
                Type key = types2[0];
                if (!(key instanceof Class) || key != String.class) {
                    throw new JsonException("not support the " + accessibleObject);
                }
                Type elementType = types2[1];
                parserMetaInfo.setType(ComplexTypeParser.getImplClass(type));
                parserMetaInfo.setParser(new MapParser(elementType));
            } else {
                parserMetaInfo.setType(type);
                parserMetaInfo.setParser(ParserStateMachine.getParser(type, ((Field)accessibleObject).getAnnotation(DateFormat.class)));
            }
            fieldSet.add(parserMetaInfo);
        }
        parserMetaInfos = fieldSet.toArray(EMPTY_ARRAY);
        if (parserMetaInfos.length <= 0) {
            throw new JsonException("not support the " + clazz.getName());
        }
        return parserMetaInfos;
    }
}

