/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.io;

import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.concurrent.CountingCallback;
import com.firefly.utils.io.BufferReaderHandler;
import com.firefly.utils.io.LineReaderHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public abstract class FileUtils {
    public static final long FILE_READER_BUFFER_SIZE = 8192L;

    public static void recursiveDelete(File dir) {
        dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    FileUtils.recursiveDelete(f);
                } else {
                    f.delete();
                }
                return false;
            }
        });
        dir.delete();
    }

    public static void read(File file, LineReaderHandler handler, String charset) throws IOException {
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                handler.readline(line, reader.getLineNumber());
            }
        }
    }

    public static String readFileToString(File file, String charset) throws IOException {
        StringBuilder s = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), charset);){
            char[] buf = new char[1024];
            int length = 0;
            while ((length = reader.read(buf)) != -1) {
                s.append(buf, 0, length);
            }
        }
        return s.length() <= 0 ? null : s.toString();
    }

    public static long copy(File src, File dest) throws IOException {
        return FileUtils.copy(src, dest, 0L, src.length());
    }

    /*
     * Exception decompiling
     */
    public static long copy(File src, File dest, long position, long length) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long transferTo(File file, Callback callback, BufferReaderHandler handler) throws IOException {
        try (FileChannel fc = FileChannel.open(Paths.get(file.toURI()), StandardOpenOption.READ);){
            long l = FileUtils.transferTo(fc, file.length(), callback, handler);
            return l;
        }
    }

    public static long transferTo(File file, long pos, long len, Callback callback, BufferReaderHandler handler) throws IOException {
        try (FileChannel fc = FileChannel.open(Paths.get(file.toURI()), StandardOpenOption.READ);){
            long l = FileUtils.transferTo(fc, pos, len, callback, handler);
            return l;
        }
    }

    public static long transferTo(FileChannel fileChannel, long len, Callback callback, BufferReaderHandler handler) throws IOException {
        long bufferSize = Math.min(8192L, len);
        long count = 0L;
        long bufferCount = (len + bufferSize - 1L) / bufferSize;
        CountingCallback countingCallback = new CountingCallback(callback, (int)bufferCount);
        try (FileChannel fc = fileChannel;){
            ByteBuffer buf = ByteBuffer.allocate((int)bufferSize);
            int i = 0;
            while ((i = fc.read(buf)) != -1) {
                if (i > 0) {
                    buf.flip();
                    handler.readBuffer(buf, countingCallback, count += (long)i);
                }
                if (count >= len) {
                    break;
                }
                buf = ByteBuffer.allocate((int)bufferSize);
            }
        }
        return count;
    }

    public static long transferTo(FileChannel fileChannel, long pos, long len, Callback callback, BufferReaderHandler handler) throws IOException {
        long bufferSize = Math.min(8192L, len);
        long count = 0L;
        long bufferCount = (len + bufferSize - 1L) / bufferSize;
        CountingCallback countingCallback = new CountingCallback(callback, (int)bufferCount);
        try (FileChannel fc = fileChannel;){
            ByteBuffer buf = ByteBuffer.allocate((int)bufferSize);
            int i = 0;
            while ((i = fc.read(buf, pos)) != -1) {
                if (i > 0) {
                    pos += (long)i;
                    buf.flip();
                    handler.readBuffer(buf, countingCallback, count += (long)i);
                }
                if (count >= len) {
                    break;
                }
                buf = ByteBuffer.allocate((int)Math.min(8192L, len - count));
            }
        }
        return count;
    }
}

