/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.io;

import com.firefly.utils.io.PipedStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class FilePipedStream
implements PipedStream {
    private OutputStream out;
    private InputStream in;
    private File temp;

    public FilePipedStream(String tempdir) {
        this.temp = new File(tempdir, UUID.randomUUID().toString());
    }

    public FilePipedStream(File file) {
        this.temp = file;
    }

    @Override
    public void close() throws IOException {
        if (this.temp == null) {
            return;
        }
        try {
            this.temp.delete();
        }
        finally {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        this.in = null;
        this.out = null;
        this.temp = null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new BufferedInputStream(new FileInputStream(this.temp));
        }
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new BufferedOutputStream(new FileOutputStream(this.temp));
        }
        return this.out;
    }
}

