/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.io;

import com.firefly.utils.io.PipedStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayPipedStream
implements PipedStream {
    private ByteArrayOutputStream out;
    private ByteArrayInputStream in;
    private int length;

    public ByteArrayPipedStream(int length) {
        if (length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("http body length too larger");
        }
        this.length = length;
    }

    @Override
    public void close() throws IOException {
        this.in = null;
        this.out = null;
    }

    @Override
    public InputStream getInputStream() {
        if (this.in == null) {
            this.in = new ByteArrayInputStream(this.out.toByteArray());
            this.out = null;
        }
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = new ByteArrayOutputStream(this.length);
        }
        return this.out;
    }
}

