/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private static final int DEFAULT_BUFFER_BIT_LEN = 10;
    protected byte[] buf;
    protected int bufbitlen;
    protected int bufsize;
    protected long bufmask;
    protected boolean bufdirty;
    protected int bufusedsize;
    protected long curpos;
    protected long bufstartpos;
    protected long bufendpos;
    protected long fileendpos;
    protected boolean append;
    protected String filename;
    protected long initfilelen;

    public BufferedRandomAccessFile(String name) throws IOException {
        this(name, "r", 10);
    }

    public BufferedRandomAccessFile(File file) throws IOException, FileNotFoundException {
        this(file.getPath(), "r", 10);
    }

    public BufferedRandomAccessFile(String name, int bufbitlen) throws IOException {
        this(name, "r", bufbitlen);
    }

    public BufferedRandomAccessFile(File file, int bufbitlen) throws IOException, FileNotFoundException {
        this(file.getPath(), "r", bufbitlen);
    }

    public BufferedRandomAccessFile(String name, String mode) throws IOException {
        this(name, mode, 10);
    }

    public BufferedRandomAccessFile(File file, String mode) throws IOException, FileNotFoundException {
        this(file.getPath(), mode, 10);
    }

    public BufferedRandomAccessFile(String name, String mode, int bufbitlen) throws IOException {
        super(name, mode);
        this.init(name, mode, bufbitlen);
    }

    public BufferedRandomAccessFile(File file, String mode, int bufbitlen) throws IOException, FileNotFoundException {
        this(file.getPath(), mode, bufbitlen);
    }

    private void init(String name, String mode, int bufbitlen) throws IOException {
        this.append = !mode.equals("r");
        this.filename = name;
        this.initfilelen = super.length();
        this.fileendpos = this.initfilelen - 1L;
        this.curpos = super.getFilePointer();
        if (bufbitlen < 0) {
            throw new IllegalArgumentException("bufbitlen size must >= 0");
        }
        this.bufbitlen = bufbitlen;
        this.bufsize = 1 << bufbitlen;
        this.buf = new byte[this.bufsize];
        this.bufmask = (long)this.bufsize - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        this.bufdirty = false;
        this.bufusedsize = 0;
        this.bufstartpos = -1L;
        this.bufendpos = -1L;
    }

    private void flushbuf() throws IOException {
        if (this.bufdirty) {
            if (super.getFilePointer() != this.bufstartpos) {
                super.seek(this.bufstartpos);
            }
            super.write(this.buf, 0, this.bufusedsize);
            this.bufdirty = false;
        }
    }

    private int fillbuf() throws IOException {
        super.seek(this.bufstartpos);
        this.bufdirty = false;
        return super.read(this.buf);
    }

    public byte read(long pos) throws IOException {
        if (pos < this.bufstartpos || pos > this.bufendpos) {
            this.flushbuf();
            this.seek(pos);
            if (pos < this.bufstartpos || pos > this.bufendpos) {
                throw new IOException();
            }
        }
        this.curpos = pos;
        return this.buf[(int)(pos - this.bufstartpos)];
    }

    public boolean write(byte bw) throws IOException {
        return this.write(bw, this.curpos);
    }

    public boolean append(byte bw) throws IOException {
        return this.write(bw, this.fileendpos + 1L);
    }

    public boolean write(byte bw, long pos) throws IOException {
        if (pos >= this.bufstartpos && pos <= this.bufendpos) {
            this.buf[(int)(pos - this.bufstartpos)] = bw;
            this.bufdirty = true;
            if (pos == this.fileendpos + 1L) {
                ++this.fileendpos;
                ++this.bufusedsize;
            }
        } else {
            this.seek(pos);
            if (pos >= 0L && pos <= this.fileendpos && this.fileendpos != 0L) {
                this.buf[(int)(pos - this.bufstartpos)] = bw;
            } else if (pos == 0L && this.fileendpos == 0L || pos == this.fileendpos + 1L) {
                this.buf[0] = bw;
                ++this.fileendpos;
                this.bufusedsize = 1;
            } else {
                throw new IndexOutOfBoundsException();
            }
            this.bufdirty = true;
        }
        this.curpos = pos;
        return true;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long writeendpos = this.curpos + (long)len - 1L;
        if (writeendpos <= this.bufendpos) {
            System.arraycopy(b, off, this.buf, (int)(this.curpos - this.bufstartpos), len);
            this.bufdirty = true;
            this.bufusedsize = (int)(writeendpos - this.bufstartpos + 1L);
        } else {
            super.seek(this.curpos);
            super.write(b, off, len);
        }
        if (writeendpos > this.fileendpos) {
            this.fileendpos = writeendpos;
        }
        this.seek(writeendpos + 1L);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long readendpos = this.curpos + (long)len - 1L;
        if (readendpos <= this.bufendpos && readendpos <= this.fileendpos) {
            System.arraycopy(this.buf, (int)(this.curpos - this.bufstartpos), b, off, len);
        } else {
            if (readendpos > this.fileendpos) {
                len = (int)(this.length() - this.curpos + 1L);
            }
            super.seek(this.curpos);
            len = super.read(b, off, len);
            readendpos = this.curpos + (long)len - 1L;
        }
        this.seek(readendpos + 1L);
        return len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < this.bufstartpos || pos > this.bufendpos) {
            this.flushbuf();
            if (pos >= 0L && pos <= this.fileendpos && this.fileendpos != 0L) {
                this.bufstartpos = pos & this.bufmask;
                this.bufusedsize = this.fillbuf();
            } else if (pos == 0L && this.fileendpos == 0L || pos == this.fileendpos + 1L) {
                this.bufstartpos = pos;
                this.bufusedsize = 0;
            }
            this.bufendpos = this.bufstartpos + (long)this.bufsize - 1L;
        }
        this.curpos = pos;
    }

    @Override
    public long length() throws IOException {
        return this.max(this.fileendpos + 1L, this.initfilelen);
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.fileendpos = newLength > 0L ? newLength - 1L : 0L;
        super.setLength(newLength);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.curpos;
    }

    private long max(long a, long b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    @Override
    public void close() throws IOException {
        this.flushbuf();
        super.close();
    }

    public static void main(String[] args) throws IOException {
        int readcount;
        long readfilelen = 0L;
        BufferedRandomAccessFile brafReadFile = new BufferedRandomAccessFile("C:/Windows/Fonts/STKAITI.TTF");
        readfilelen = brafReadFile.initfilelen;
        BufferedRandomAccessFile brafWriteFile = new BufferedRandomAccessFile("D:/STKAITI.001", "rw", 10);
        byte[] buf = new byte[1024];
        long start = System.currentTimeMillis();
        while ((readcount = brafReadFile.read(buf)) != -1) {
            brafWriteFile.write(buf, 0, readcount);
        }
        brafWriteFile.close();
        brafReadFile.close();
        System.out.println("BufferedRandomAccessFile Copy & Write File: " + brafReadFile.filename + "    FileSize: " + Integer.toString((int)readfilelen >> 1024) + " (KB)    Spend: " + (double)(System.currentTimeMillis() - start) / 1000.0 + "(s)");
        FileInputStream fdin = new FileInputStream("C:/Windows/Fonts/STKAITI.TTF");
        BufferedInputStream bis = new BufferedInputStream(fdin, 1024);
        DataInputStream dis = new DataInputStream(bis);
        FileOutputStream fdout = new FileOutputStream("D:/STKAITI.002");
        BufferedOutputStream bos = new BufferedOutputStream(fdout, 1024);
        DataOutputStream dos = new DataOutputStream(bos);
        start = System.currentTimeMillis();
        int i = 0;
        while ((long)i < readfilelen) {
            dos.write(dis.readByte());
            ++i;
        }
        dos.close();
        dis.close();
        System.out.println("DataBufferedios Copy & Write File: " + brafReadFile.filename + "    FileSize: " + Integer.toString((int)readfilelen >> 1024) + " (KB)    Spend: " + (double)(System.currentTimeMillis() - start) / 1000.0 + "(s)");
    }
}

