/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.dom;

import com.firefly.utils.StringUtils;
import com.firefly.utils.dom.Dom;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultDom
implements Dom {
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private DocumentBuilder db;

    public DefaultDom() {
        try {
            this.db = this.dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Document getDocument(String file) {
        try (InputStream is = DefaultDom.class.getResourceAsStream("/" + file);){
            Document doc;
            if (is == null) {
                Document document2 = null;
                return document2;
            }
            Document document = doc = this.db.parse(is);
            return document;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            System.err.println("load xml file " + file + " exception");
        }
        return null;
    }

    @Override
    public Element getRoot(Document doc) {
        return doc.getDocumentElement();
    }

    @Override
    public List<Element> elements(Element e) {
        return this.elements(e, null);
    }

    @Override
    public List<Element> elements(Element e, String name) {
        ArrayList<Element> eList = new ArrayList<Element>();
        NodeList nodeList = e.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (name != null) {
                if (!node.getNodeName().equals(name)) continue;
                eList.add((Element)node);
                continue;
            }
            eList.add((Element)node);
        }
        return eList;
    }

    @Override
    public Element element(Element e, String name) {
        NodeList element = e.getElementsByTagName(name);
        if (element != null && e.getNodeType() == 1) {
            return (Element)element.item(0);
        }
        return null;
    }

    @Override
    public String getTextValue(Element valueElement) {
        if (valueElement != null) {
            StringBuilder sb = new StringBuilder();
            NodeList nl = valueElement.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node item = nl.item(i);
                if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
                sb.append(item.getNodeValue());
            }
            return sb.toString().trim();
        }
        return null;
    }

    @Override
    public String getTextValueByTagName(Element e, String name) {
        Element valueElement = this.element(e, name);
        if (valueElement == null) {
            return null;
        }
        String value = this.getTextValue(valueElement);
        if (StringUtils.hasText(value)) {
            return value;
        }
        return null;
    }

    @Override
    public String getTextValueByTagName(Element e, String name, String defaultValue) {
        String value = this.getTextValueByTagName(e, name);
        return StringUtils.hasText(value) ? value : defaultValue;
    }
}

