/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.concurrent;

import com.firefly.utils.log.Log;
import com.firefly.utils.log.LogFactory;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;

public class SynchronousObject<T> {
    private static Log log = LogFactory.getInstance().getLog("firefly-system");
    private SynchronousQueue<T> queue = new SynchronousQueue();

    public void put(T obj, long timeout) {
        try {
            this.queue.offer(obj, timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.error("put synchronous obj error", e, new Object[0]);
        }
    }

    public T get(long timeout) {
        T t = null;
        try {
            t = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.error("get synchronous obj error", e, new Object[0]);
        }
        return t;
    }
}

