/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.concurrent;

import com.firefly.utils.concurrent.Scheduler;
import com.firefly.utils.lang.AbstractLifeCycle;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class Schedulers {
    private static ThreadFactory factory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable target) {
            return new Thread(target, "firefly scheduler");
        }
    };
    private static int coreSize = Runtime.getRuntime().availableProcessors();

    private Schedulers() {
    }

    private static Scheduler wrapScheduledExecutorService(ScheduledExecutorService service) {
        return new SchedulerService(service);
    }

    public static Scheduler createScheduler(int corePoolSize) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(corePoolSize, factory);
        executor.setRemoveOnCancelPolicy(true);
        return Schedulers.wrapScheduledExecutorService(executor);
    }

    public static Scheduler createScheduler() {
        return Schedulers.createScheduler(1);
    }

    public static Scheduler computation() {
        return Schedulers.createScheduler(coreSize);
    }

    public static class SchedulerService
    extends AbstractLifeCycle
    implements Scheduler {
        private final ScheduledExecutorService service;

        public SchedulerService(ScheduledExecutorService service) {
            this.service = service;
        }

        @Override
        public Scheduler.Future schedule(Runnable task, long delay, TimeUnit unit) {
            this.start();
            return this.wrapScheduledFuture(this.service.schedule(task, delay, unit));
        }

        @Override
        public Scheduler.Future scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
            this.start();
            return this.wrapScheduledFuture(this.service.scheduleWithFixedDelay(task, initialDelay, delay, unit));
        }

        @Override
        public Scheduler.Future scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
            this.start();
            return this.wrapScheduledFuture(this.service.scheduleAtFixedRate(task, initialDelay, period, unit));
        }

        @Override
        protected void init() {
        }

        @Override
        protected void destroy() {
            this.service.shutdown();
        }

        private Scheduler.Future wrapScheduledFuture(ScheduledFuture<?> future) {
            return () -> future.cancel(false);
        }
    }
}

