/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.concurrent;

import java.util.concurrent.CompletableFuture;

public interface Promise<C> {
    default public void succeeded(C result) {
    }

    default public void failed(Throwable x) {
    }

    public static <T> Promise<T> from(final CompletableFuture<? super T> completable) {
        if (completable instanceof Promise) {
            return (Promise)((Object)completable);
        }
        return new Promise<T>(){

            @Override
            public void succeeded(T result) {
                completable.complete(result);
            }

            @Override
            public void failed(Throwable x) {
                completable.completeExceptionally(x);
            }
        };
    }

    public static class Completable<S>
    extends CompletableFuture<S>
    implements Promise<S> {
        @Override
        public void succeeded(S result) {
            this.complete(result);
        }

        @Override
        public void failed(Throwable x) {
            this.completeExceptionally(x);
        }
    }

    public static class Adapter<U>
    implements Promise<U> {
        @Override
        public void succeeded(U result) {
        }

        @Override
        public void failed(Throwable x) {
            x.printStackTrace();
        }
    }
}

