/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.concurrent;

import com.firefly.utils.concurrent.Scheduler;
import com.firefly.utils.time.Millisecond100Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public abstract class IdleTimeout {
    private final Scheduler scheduler;
    private final AtomicReference<Scheduler.Future> timeout = new AtomicReference();
    private volatile long idleTimeout;
    private volatile long idleTimestamp = Millisecond100Clock.currentTimeMillis();
    private final Runnable idleTask = new Runnable(){

        @Override
        public void run() {
            long idleLeft = IdleTimeout.this.checkIdleTimeout();
            if (idleLeft >= 0L) {
                IdleTimeout.this.scheduleIdleTimeout(idleLeft > 0L ? idleLeft : IdleTimeout.this.getIdleTimeout());
            }
        }
    };

    public IdleTimeout(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public long getIdleTimestamp() {
        return this.idleTimestamp;
    }

    public long getIdleFor() {
        return Millisecond100Clock.currentTimeMillis() - this.getIdleTimestamp();
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        long old = idleTimeout;
        this.idleTimeout = idleTimeout;
        if (old > 0L) {
            if (old <= idleTimeout) {
                return;
            }
            this.deactivate();
        }
        if (this.isOpen()) {
            this.activate();
        }
    }

    public void notIdle() {
        this.idleTimestamp = Millisecond100Clock.currentTimeMillis();
    }

    private void scheduleIdleTimeout(long delay) {
        Scheduler.Future oldTimeout;
        Scheduler.Future newTimeout = null;
        if (this.isOpen() && delay > 0L && this.scheduler != null) {
            newTimeout = this.scheduler.schedule(this.idleTask, delay, TimeUnit.MILLISECONDS);
        }
        if ((oldTimeout = (Scheduler.Future)this.timeout.getAndSet(newTimeout)) != null) {
            oldTimeout.cancel();
        }
    }

    public void onOpen() {
        this.activate();
    }

    private void activate() {
        if (this.idleTimeout > 0L) {
            this.idleTask.run();
        }
    }

    public void onClose() {
        this.deactivate();
    }

    private void deactivate() {
        Scheduler.Future oldTimeout = this.timeout.getAndSet(null);
        if (oldTimeout != null) {
            oldTimeout.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long checkIdleTimeout() {
        if (this.isOpen()) {
            long idleTimestamp = this.getIdleTimestamp();
            long idleTimeout = this.getIdleTimeout();
            long idleElapsed = Millisecond100Clock.currentTimeMillis() - idleTimestamp;
            long idleLeft = idleTimeout - idleElapsed;
            if (idleTimestamp != 0L && idleTimeout > 0L && idleLeft <= 0L) {
                try {
                    this.onIdleExpired(new TimeoutException("Idle timeout expired: " + idleElapsed + "/" + idleTimeout + " ms"));
                }
                finally {
                    this.notIdle();
                }
            }
            return idleLeft >= 0L ? idleLeft : 0L;
        }
        return -1L;
    }

    protected abstract void onIdleExpired(TimeoutException var1);

    public abstract boolean isOpen();
}

