/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.concurrent;

import java.util.concurrent.CompletableFuture;

public interface Callback {
    public static final Callback NOOP = new Callback(){};

    default public void succeeded() {
    }

    default public void failed(Throwable x) {
    }

    default public boolean isNonBlocking() {
        return false;
    }

    public static Callback from(CompletableFuture<?> completable) {
        return Callback.from(completable, false);
    }

    public static Callback from(final CompletableFuture<?> completable, final boolean blocking) {
        if (completable instanceof Callback) {
            return (Callback)((Object)completable);
        }
        return new Callback(){

            @Override
            public void succeeded() {
                completable.complete(null);
            }

            @Override
            public void failed(Throwable x) {
                completable.completeExceptionally(x);
            }

            @Override
            public boolean isNonBlocking() {
                return !blocking;
            }
        };
    }

    public static class Completable
    extends CompletableFuture<Void>
    implements Callback {
        private final boolean blocking;

        public Completable() {
            this(false);
        }

        public Completable(boolean blocking) {
            this.blocking = blocking;
        }

        @Override
        public void succeeded() {
            this.complete(null);
        }

        @Override
        public void failed(Throwable x) {
            this.completeExceptionally(x);
        }

        @Override
        public boolean isNonBlocking() {
            return !this.blocking;
        }
    }

    public static class Nested
    implements Callback {
        private final Callback callback;

        public Nested(Callback callback) {
            this.callback = callback;
        }

        public Nested(Nested nested) {
            this.callback = nested.callback;
        }

        @Override
        public void succeeded() {
            this.callback.succeeded();
        }

        @Override
        public void failed(Throwable x) {
            this.callback.failed(x);
        }

        @Override
        public boolean isNonBlocking() {
            return this.callback.isNonBlocking();
        }
    }

    public static interface NonBlocking
    extends Callback {
        @Override
        default public boolean isNonBlocking() {
            return true;
        }
    }
}

