/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.collection;

import java.util.AbstractList;

public final class HashedArrayTree<T>
extends AbstractList<T> {
    private static final int kMinArraySize = 2;
    private T[][] mArrays = new Object[2][];
    private int mSize = 0;
    private int mLgSize = 1;

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public boolean add(T elem) {
        if (this.size() == this.mArrays.length * this.mArrays.length) {
            this.grow();
        }
        int offset = this.computeOffset(this.size());
        int index = this.computeIndex(this.size());
        if (this.mArrays[offset] == null) {
            this.mArrays[offset] = new Object[this.mArrays.length];
        }
        this.mArrays[offset][index] = elem;
        ++this.mSize;
        return true;
    }

    @Override
    public T set(int index, T elem) {
        int offset = this.computeOffset(index);
        int arrIndex = this.computeIndex(index);
        T result = this.mArrays[offset][arrIndex];
        this.mArrays[offset][arrIndex] = elem;
        return result;
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + ", size " + this.size());
        }
        return this.mArrays[this.computeOffset(index)][this.computeIndex(index)];
    }

    @Override
    public void add(int index, T elem) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + ", size " + this.size());
        }
        this.add((T)null);
        for (int i = this.size(); i > index; ++i) {
            this.set(i, this.get(i - 1));
        }
        this.set(index, elem);
    }

    @Override
    public T remove(int index) {
        T result = this.get(index);
        for (int i = index + 1; i < this.size(); ++i) {
            this.set(i - 1, this.get(i));
        }
        this.set(this.size() - 1, (T)null);
        --this.mSize;
        if (this.size() * 8 <= this.mArrays.length * this.mArrays.length) {
            this.shrink();
        } else if (this.size() % this.mArrays.length == 0) {
            this.mArrays[this.computeOffset((int)this.size())] = null;
        }
        return result;
    }

    private int computeOffset(int index) {
        return index >> this.mLgSize;
    }

    private int computeIndex(int index) {
        return index & this.mArrays.length - 1;
    }

    private void grow() {
        Object[][] newArrays = new Object[this.mArrays.length * 2][];
        for (int i = 0; i < this.mArrays.length; i += 2) {
            newArrays[i / 2] = new Object[newArrays.length];
            System.arraycopy(this.mArrays[i], 0, newArrays[i / 2], 0, this.mArrays.length);
            System.arraycopy(this.mArrays[i + 1], 0, newArrays[i / 2], this.mArrays.length, this.mArrays.length);
            this.mArrays[i + 1] = null;
            this.mArrays[i] = null;
        }
        this.mArrays = newArrays;
        ++this.mLgSize;
    }

    private void shrink() {
        if (this.mArrays.length == 2) {
            return;
        }
        Object[][] newArrays = new Object[this.mArrays.length / 2][];
        for (int i = 0; i < newArrays.length / 2; ++i) {
            newArrays[i] = new Object[newArrays.length];
            System.arraycopy(this.mArrays[i / 2], i % 2 == 0 ? 0 : newArrays.length, newArrays[i], 0, newArrays.length);
            if (i % 2 != 1) continue;
            this.mArrays[i / 2] = null;
        }
        this.mArrays = newArrays;
        --this.mLgSize;
    }
}

