/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.collection;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class ConsistentHash<T> {
    private HashFunction hashFunction = new HashFunction(){

        @Override
        public int hash(Object o) {
            return o.hashCode();
        }

        @Override
        public int hashWithVirtualNodeIndex(Object o, int index) {
            return this.hash(o.toString() + "_" + index);
        }
    };
    private int numberOfReplicas = 4;
    private NavigableMap<Integer, T> circle = new ConcurrentSkipListMap<Integer, T>();

    public ConsistentHash() {
    }

    public ConsistentHash(int numberOfReplicas) {
        this(null, numberOfReplicas, null);
    }

    public ConsistentHash(HashFunction hashFunction) {
        this(hashFunction, 0, null);
    }

    public ConsistentHash(HashFunction hashFunction, int numberOfReplicas, NavigableMap<Integer, T> circle) {
        this(hashFunction, numberOfReplicas, circle, null);
    }

    public ConsistentHash(HashFunction hashFunction, int numberOfReplicas, NavigableMap<Integer, T> circle, Collection<T> nodes) {
        if (hashFunction != null) {
            this.hashFunction = hashFunction;
        }
        if (numberOfReplicas > 0) {
            this.numberOfReplicas = numberOfReplicas;
        }
        if (circle != null) {
            this.circle = circle;
        }
        if (nodes != null) {
            for (T node : nodes) {
                this.add(node);
            }
        }
    }

    public void add(T node) {
        for (int i = 0; i < this.numberOfReplicas; ++i) {
            this.circle.put(this.hashFunction.hashWithVirtualNodeIndex(node, i), node);
        }
    }

    public void remove(T node) {
        for (int i = 0; i < this.numberOfReplicas; ++i) {
            this.circle.remove(this.hashFunction.hashWithVirtualNodeIndex(node, i));
        }
    }

    public T get(Object key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        int hash = this.hashFunction.hash(key);
        Object t = this.circle.get(key);
        if (t != null) {
            return (T)t;
        }
        Map.Entry<Integer, T> entry = this.circle.higherEntry(hash);
        return entry == null ? this.circle.firstEntry().getValue() : entry.getValue();
    }

    public static interface HashFunction {
        public int hash(Object var1);

        public int hashWithVirtualNodeIndex(Object var1, int var2);
    }
}

