/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentLinkedHashMap<K, V>
implements Map<K, V> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private final int segmentMask;
    private final int segmentShift;
    private final int concurrencyLevel;
    private final LinkedHashMapSegment<K, V>[] segments;
    private final MapEventListener<K, V> mapEventListener;

    public ConcurrentLinkedHashMap(boolean accessOrder, int maxEntries, MapEventListener<K, V> mapEventListener) {
        this(accessOrder, maxEntries, mapEventListener, 16);
    }

    public ConcurrentLinkedHashMap(boolean accessOrder, int maxEntries, MapEventListener<K, V> mapEventListener, int concurrencyLevel) {
        this(16, 0.75f, accessOrder, maxEntries, mapEventListener, concurrencyLevel);
    }

    public ConcurrentLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder, int maxEntries, MapEventListener<K, V> mapEventListener, int concurrencyLevel) {
        this.mapEventListener = mapEventListener;
        int cLevel = concurrencyLevel > 0 ? concurrencyLevel : 16;
        int level = 1;
        int sshift = 0;
        while (level < cLevel) {
            level <<= 1;
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = level - 1;
        this.concurrencyLevel = level;
        this.segments = new LinkedHashMapSegment[this.concurrencyLevel];
        for (int i = 0; i < this.segments.length; ++i) {
            LinkedHashMapSegment<K, V> segment = new LinkedHashMapSegment<K, V>(initialCapacity, loadFactor, accessOrder, maxEntries <= this.concurrencyLevel ? 1 : maxEntries / this.concurrencyLevel, mapEventListener);
            this.segments[i] = segment;
        }
    }

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    private final LinkedHashMapSegment<K, V> segmentFor(int hash) {
        int h = ConcurrentLinkedHashMap.hash(hash);
        return this.segments[h >>> this.segmentShift & this.segmentMask];
    }

    private void lockAllSegments() {
        for (LinkedHashMapSegment<K, V> seg : this.segments) {
            seg.lock.lock();
        }
    }

    private void unlockAllSegments() {
        for (LinkedHashMapSegment<K, V> seg : this.segments) {
            seg.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            this.lockAllSegments();
            int size = 0;
            for (LinkedHashMapSegment<K, V> seg : this.segments) {
                size += seg.size();
            }
            int n = size;
            return n;
        }
        finally {
            this.unlockAllSegments();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        try {
            this.lockAllSegments();
            for (LinkedHashMapSegment<K, V> seg : this.segments) {
                if (seg.isEmpty()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlockAllSegments();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        try {
            this.lockAllSegments();
            for (LinkedHashMapSegment<K, V> seg : this.segments) {
                if (!seg.containsValue(value)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlockAllSegments();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        LinkedHashMapSegment<K, V> seg = this.segmentFor(key.hashCode());
        try {
            seg.lock.lock();
            V v = this.mapEventListener.onGetEntry(key, seg.get(key));
            return v;
        }
        finally {
            seg.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        LinkedHashMapSegment<K, V> seg = this.segmentFor(key.hashCode());
        try {
            seg.lock.lock();
            V v = this.mapEventListener.onPutEntry(key, value, seg.put(key, value));
            return v;
        }
        finally {
            seg.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        LinkedHashMapSegment<K, V> seg = this.segmentFor(key.hashCode());
        try {
            seg.lock.lock();
            V v = this.mapEventListener.onRemoveEntry(key, seg.remove(key));
            return v;
        }
        finally {
            seg.lock.unlock();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this.lockAllSegments();
            for (LinkedHashMapSegment<K, V> seg : this.segments) {
                seg.clear();
            }
        }
        finally {
            this.unlockAllSegments();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        try {
            this.lockAllSegments();
            HashSet set = new HashSet();
            for (LinkedHashMapSegment<K, V> seg : this.segments) {
                set.addAll(seg.keySet());
            }
            HashSet hashSet = set;
            return hashSet;
        }
        finally {
            this.unlockAllSegments();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        try {
            this.lockAllSegments();
            ArrayList collection = new ArrayList();
            for (LinkedHashMapSegment<K, V> seg : this.segments) {
                collection.addAll(seg.values());
            }
            ArrayList arrayList = collection;
            return arrayList;
        }
        finally {
            this.unlockAllSegments();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        try {
            this.lockAllSegments();
            HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
            for (LinkedHashMapSegment<K, V> seg : this.segments) {
                set.addAll(seg.entrySet());
            }
            HashSet<Map.Entry<K, V>> hashSet = set;
            return hashSet;
        }
        finally {
            this.unlockAllSegments();
        }
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public int getSegmentShift() {
        return this.segmentShift;
    }

    public int getSegmentMask() {
        return this.segmentMask;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.segments.length; ++i) {
            s.append("segment " + i + " -> " + this.segments[i].toString());
            s.append("\r\n");
        }
        return s.toString();
    }

    static final class LinkedHashMapSegment<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 3135160986591665845L;
        private final int maxEntries;
        private final MapEventListener<K, V> mapEventListener;
        final Lock lock = new ReentrantLock();

        public int getMaxEntries() {
            return this.maxEntries;
        }

        public LinkedHashMapSegment(int initialCapacity, float loadFactor, boolean accessOrder, int maxEntries, MapEventListener<K, V> mapEventListener) {
            super(initialCapacity, loadFactor, accessOrder);
            this.maxEntries = maxEntries;
            this.mapEventListener = mapEventListener;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            this.lock.lock();
            try {
                if (this.size() > this.maxEntries) {
                    boolean bl = this.mapEventListener.onEliminateEntry(eldest.getKey(), eldest.getValue());
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static interface MapEventListener<K, V> {
        public boolean onEliminateEntry(K var1, V var2);

        public V onGetEntry(K var1, V var2);

        public V onPutEntry(K var1, V var2, V var3);

        public V onRemoveEntry(K var1, V var2);
    }
}

