/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.collection;

import com.firefly.utils.collection.ConcurrentAutomaticClearMap;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractConcurrentAutomaticClearMap<K, V>
implements ConcurrentAutomaticClearMap<K, V>,
ConcurrentMap<K, V> {
    protected Map<K, Reference<V>> map = new ConcurrentHashMap<K, Reference<V>>();
    protected ReferenceQueue<V> refQueue = new ReferenceQueue();

    @Override
    public void clearAllInvalidEntry() {
        Reference<V> ref;
        while ((ref = this.refQueue.poll()) != null) {
            this.clearInvalidEntry(ref);
        }
    }

    protected abstract void clearInvalidEntry(Reference<? extends V> var1);

    protected abstract Reference<V> createRefence(K var1, V var2);

    @Override
    public int size() {
        this.clearAllInvalidEntry();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.clearAllInvalidEntry();
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public V get(Object key) {
        Reference<V> ref = this.map.get(key);
        if (ref == null) {
            return null;
        }
        V value = ref.get();
        if (value == null) {
            this.clearInvalidEntry(ref);
            return null;
        }
        return value;
    }

    @Override
    public V put(K key, V value) {
        this.clearAllInvalidEntry();
        Reference<V> ref = this.map.put(key, this.createRefence(key, value));
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.clearAllInvalidEntry();
        Reference<V> ref = this.map.putIfAbsent(key, this.createRefence(key, value));
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.clearAllInvalidEntry();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V replace(K key, V value) {
        Reference<V> ref = this.map.replace(key, this.createRefence(key, value));
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.map.replace(key, this.createRefence(key, oldValue), this.createRefence(key, newValue));
    }

    @Override
    public V remove(Object key) {
        this.clearAllInvalidEntry();
        Reference<V> ref = this.map.remove(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.clearAllInvalidEntry();
        return this.map.remove(key, this.createRefence(key, value));
    }

    @Override
    public void clear() {
        this.clearAllInvalidEntry();
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        LinkedList<V> collection = new LinkedList<V>();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            collection.add(entry.getValue());
        }
        return collection;
    }

    @Override
    public boolean containsValue(Object value) {
        for (V v : this.values()) {
            if (v == null || !v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, Reference<V>> entry : this.map.entrySet()) {
            Reference<V> ref = entry.getValue();
            V value = ref.get();
            if (value == null) {
                this.clearInvalidEntry(ref);
                continue;
            }
            set.add(new MapEntryImpl(entry.getKey(), value));
        }
        return set;
    }

    protected class MapEntryImpl
    implements Map.Entry<K, V> {
        K key;
        V value;

        public MapEntryImpl(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return value;
        }

        public String toString() {
            return "MapEntry [key=" + this.key + ", value=" + this.value + "]";
        }
    }
}

