/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.codec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class HuffmanCodec<T>
implements Serializable {
    private static final long serialVersionUID = -5318250039712365557L;
    private Map<T, HuffmanCode> codecMap;
    private HuffmanTree<T> huffmanTree;

    public HuffmanCodec() {
    }

    public HuffmanCodec(T[] elements) {
        this.huffmanTree = HuffmanCodec.buildHuffmanTree(elements);
        this.codecMap = HuffmanCodec.buildHuffmanCodeMap(this.huffmanTree);
    }

    public Map<T, HuffmanCode> getCodecMap() {
        return this.codecMap;
    }

    public HuffmanTree<T> getHuffmanTree() {
        return this.huffmanTree;
    }

    public void setCodecMap(Map<T, HuffmanCode> codecMap) {
        this.codecMap = codecMap;
    }

    public void setHuffmanTree(HuffmanTree<T> huffmanTree) {
        this.huffmanTree = huffmanTree;
    }

    public BitBuilder encode(T[] elements) {
        BitBuilder bits = new BitBuilder();
        for (T t : elements) {
            HuffmanCode code = this.codecMap.get(t);
            for (int j = 0; j < code.length; ++j) {
                bits.append(code.bitBuilder.get(j));
            }
        }
        return bits;
    }

    public List<T> decode(BitBuilder bits) {
        ArrayList elements = new ArrayList();
        HuffmanTree<T> currentNode = this.huffmanTree;
        for (int i = 0; i < bits.getLength(); ++i) {
            if (currentNode instanceof HuffmanNode) {
                HuffmanNode node = (HuffmanNode)currentNode;
                HuffmanTree huffmanTree = currentNode = bits.get(i) ? node.right : node.left;
            }
            if (!(currentNode instanceof HuffmanLeaf)) continue;
            HuffmanLeaf leaf = (HuffmanLeaf)currentNode;
            elements.add(leaf.value);
            currentNode = this.huffmanTree;
        }
        return elements;
    }

    public static <T> Map<T, HuffmanCode> buildHuffmanCodeMap(HuffmanTree<T> tree) {
        HashMap map = new HashMap();
        StringBuilder bits = new StringBuilder();
        HuffmanCodec._buildHuffmanCodeMap(tree, map, bits);
        return map;
    }

    private static <T> void _buildHuffmanCodeMap(HuffmanTree<T> tree, Map<T, HuffmanCode> map, StringBuilder bits) {
        if (tree instanceof HuffmanLeaf) {
            HuffmanLeaf leaf = (HuffmanLeaf)tree;
            HuffmanCode code = new HuffmanCode(leaf.frequency, bits.toString());
            map.put(leaf.value, code);
        } else if (tree instanceof HuffmanNode) {
            HuffmanNode node = (HuffmanNode)tree;
            bits.append('0');
            HuffmanCodec._buildHuffmanCodeMap(node.left, map, bits);
            bits.deleteCharAt(bits.length() - 1);
            bits.append('1');
            HuffmanCodec._buildHuffmanCodeMap(node.right, map, bits);
            bits.deleteCharAt(bits.length() - 1);
        }
    }

    public static <T> HuffmanTree<T> buildHuffmanTree(T[] elements) {
        HashMap<T, Long> frequencyMap = new HashMap<T, Long>();
        for (T t : elements) {
            Long num = (Long)frequencyMap.get(t);
            if (num == null) {
                frequencyMap.put(t, 1L);
                continue;
            }
            frequencyMap.put(t, num + 1L);
        }
        PriorityQueue<HuffmanTree> trees = new PriorityQueue<HuffmanTree>();
        for (Map.Entry entry : frequencyMap.entrySet()) {
            if (entry.getValue() == null || (Long)entry.getValue() <= 0L) continue;
            trees.offer(new HuffmanLeaf((Long)entry.getValue(), entry.getKey()));
        }
        while (trees.size() > 1) {
            HuffmanTree a = (HuffmanTree)trees.poll();
            HuffmanTree b = (HuffmanTree)trees.poll();
            trees.offer(new HuffmanNode(a, b));
        }
        return (HuffmanTree)trees.poll();
    }

    public static class BitBuilder
    extends BitSet {
        private static final long serialVersionUID = 4678685861273345213L;
        private int length;
        private int index;

        public BitBuilder() {
        }

        public BitBuilder(int len) {
            super(len);
        }

        public int getLength() {
            return this.length;
        }

        public BitBuilder append(boolean value) {
            this.set(this.index, value);
            ++this.index;
            ++this.length;
            return this;
        }
    }

    public static class HuffmanCode
    implements Serializable {
        private static final long serialVersionUID = -4696130695208200688L;
        public final Long frequency;
        public final int length;
        public final String bits;
        public final BitBuilder bitBuilder;

        public HuffmanCode(Long frequency, String bits) {
            this.frequency = frequency;
            this.length = bits.length();
            this.bits = bits;
            this.bitBuilder = new BitBuilder(this.length);
            for (int i = 0; i < bits.length(); ++i) {
                this.bitBuilder.append(bits.charAt(i) == '1');
            }
        }

        public String toString() {
            return "HuffmanCode [frequency=" + this.frequency + ", length=" + this.length + ", bits=" + this.bits + ", getBytes()=" + Arrays.toString(this.getBytes()) + "]";
        }

        public byte[] getBytes() {
            return this.bitBuilder.toByteArray();
        }
    }

    public static class HuffmanNode<T>
    extends HuffmanTree<T> {
        private static final long serialVersionUID = -4581114135719242316L;
        public final HuffmanTree<T> left;
        public final HuffmanTree<T> right;

        public HuffmanNode(HuffmanTree<T> left, HuffmanTree<T> right) {
            super(left.frequency + right.frequency);
            this.left = left;
            this.right = right;
        }
    }

    public static class HuffmanLeaf<T>
    extends HuffmanTree<T> {
        private static final long serialVersionUID = -8197406618091612264L;
        public final T value;

        public HuffmanLeaf(Long freq, T value) {
            super(freq);
            this.value = value;
        }

        public String toString() {
            return "HuffmanLeaf [value=" + this.value + ", frequency=" + this.frequency + "]";
        }
    }

    public static abstract class HuffmanTree<T>
    implements Comparable<HuffmanTree<T>>,
    Serializable {
        private static final long serialVersionUID = -5354103251920897803L;
        public final Long frequency;

        public HuffmanTree(Long frequency) {
            this.frequency = frequency;
        }

        @Override
        public int compareTo(HuffmanTree<T> tree) {
            return this.frequency.compareTo(tree.frequency);
        }
    }
}

