/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.codec;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.BitSet;

public abstract class HexUtils {
    public static final String bytesToHex(byte[] bs, int off, int length) {
        if (bs.length <= off || bs.length < off + length) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(length * 2);
        HexUtils.bytesToHexAppend(bs, off, length, sb);
        return sb.toString();
    }

    public static final void bytesToHexAppend(byte[] bs, int off, int length, StringBuilder sb) {
        if (bs.length <= off || bs.length < off + length) {
            throw new IllegalArgumentException();
        }
        sb.ensureCapacity(sb.length() + length * 2);
        for (int i = off; i < off + length; ++i) {
            sb.append(Character.forDigit(bs[i] >>> 4 & 0xF, 16));
            sb.append(Character.forDigit(bs[i] & 0xF, 16));
        }
    }

    public static final String bytesToHex(byte[] bs) {
        return HexUtils.bytesToHex(bs, 0, bs.length);
    }

    public static final byte[] hexToBytes(String s) {
        return HexUtils.hexToBytes(s, 0);
    }

    public static final byte[] hexToBytes(String s, int off) {
        byte[] bs = new byte[off + (1 + s.length()) / 2];
        HexUtils.hexToBytes(s, bs, off);
        return bs;
    }

    public static final void hexToBytes(String s, byte[] out, int off) throws NumberFormatException, IndexOutOfBoundsException {
        int slen = s.length();
        if (slen % 2 != 0) {
            s = '0' + s;
        }
        if (out.length < off + slen / 2) {
            throw new IndexOutOfBoundsException("Output buffer too small for input (" + out.length + '<' + off + slen / 2 + ')');
        }
        for (int i = 0; i < slen; i += 2) {
            byte b1 = (byte)Character.digit(s.charAt(i), 16);
            byte b2 = (byte)Character.digit(s.charAt(i + 1), 16);
            if (b1 < 0 || b2 < 0) {
                throw new NumberFormatException();
            }
            out[off + i / 2] = (byte)(b1 << 4 | b2);
        }
    }

    public static final byte[] bitsToBytes(BitSet ba, int size) {
        int bytesAlloc = HexUtils.countBytesForBits(size);
        byte[] b = new byte[bytesAlloc];
        for (int i = 0; i < b.length; ++i) {
            int s = 0;
            for (int j = 0; j < 8; ++j) {
                int idx = i * 8 + j;
                boolean val = idx > size - 1 ? false : ba.get(idx);
                s = (short)(s | (val ? 1 << j : 0));
            }
            if (s > 255) {
                throw new IllegalStateException("WTF? s = " + s);
            }
            b[i] = (byte)s;
        }
        return b;
    }

    public static final String bitsToHexString(BitSet ba, int size) {
        return HexUtils.bytesToHex(HexUtils.bitsToBytes(ba, size));
    }

    public static int countBytesForBits(int size) {
        return size / 8 + (size % 8 == 0 ? 0 : 1);
    }

    public static void bytesToBits(byte[] b, BitSet ba, int maxSize) {
        int x = 0;
        for (int i = 0; i < b.length; ++i) {
            for (int j = 0; j < 8 && x <= maxSize; ++x, ++j) {
                int mask = 1 << j;
                boolean value = (mask & b[i]) != 0;
                ba.set(x, value);
            }
        }
    }

    public static void hexToBits(String s, BitSet ba, int length) {
        byte[] b = HexUtils.hexToBytes(s);
        HexUtils.bytesToBits(b, ba, length);
    }

    public static void writeBigInteger(BigInteger integer, DataOutputStream out) throws IOException {
        if (integer.signum() == -1) {
            throw new IllegalStateException("Negative BigInteger!");
        }
        byte[] buf = integer.toByteArray();
        if (buf.length > Short.MAX_VALUE) {
            throw new IllegalStateException("Too long: " + buf.length);
        }
        out.writeShort((short)buf.length);
        out.write(buf);
    }

    public static BigInteger readBigInteger(DataInputStream dis) throws IOException {
        short i = dis.readShort();
        if (i < 0) {
            throw new IOException("Invalid BigInteger length: " + i);
        }
        byte[] buf = new byte[i];
        dis.readFully(buf);
        return new BigInteger(1, buf);
    }

    public static String biToHex(BigInteger bi) {
        return HexUtils.bytesToHex(bi.toByteArray());
    }
}

