/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.codec;

import com.firefly.utils.codec.Base64;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class Base64Utils {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Base64Delegate delegate = new CommonsCodecBase64Delegate();

    public static byte[] encode(byte[] src) {
        return delegate.encode(src);
    }

    public static byte[] decode(byte[] src) {
        return delegate.decode(src);
    }

    public static byte[] encodeUrlSafe(byte[] src) {
        return delegate.encodeUrlSafe(src);
    }

    public static byte[] decodeUrlSafe(byte[] src) {
        return delegate.decodeUrlSafe(src);
    }

    public static String encodeToString(byte[] src) {
        if (src == null) {
            return null;
        }
        if (src.length == 0) {
            return "";
        }
        return new String(delegate.encode(src), DEFAULT_CHARSET);
    }

    public static byte[] decodeFromString(String src) {
        if (src == null) {
            return null;
        }
        if (src.length() == 0) {
            return new byte[0];
        }
        return delegate.decode(src.getBytes(DEFAULT_CHARSET));
    }

    public static String encodeToUrlSafeString(byte[] src) {
        return new String(delegate.encodeUrlSafe(src), DEFAULT_CHARSET);
    }

    public static byte[] decodeFromUrlSafeString(String src) {
        return delegate.decodeUrlSafe(src.getBytes(DEFAULT_CHARSET));
    }

    static class CommonsCodecBase64Delegate
    implements Base64Delegate {
        private final Base64 base64 = new Base64();
        private final Base64 base64UrlSafe = new Base64(0, null, true);

        CommonsCodecBase64Delegate() {
        }

        @Override
        public byte[] encode(byte[] src) {
            return this.base64.encode(src);
        }

        @Override
        public byte[] decode(byte[] src) {
            return this.base64.decode(src);
        }

        @Override
        public byte[] encodeUrlSafe(byte[] src) {
            return this.base64UrlSafe.encode(src);
        }

        @Override
        public byte[] decodeUrlSafe(byte[] src) {
            return this.base64UrlSafe.decode(src);
        }
    }

    static interface Base64Delegate {
        public byte[] encode(byte[] var1);

        public byte[] decode(byte[] var1);

        public byte[] encodeUrlSafe(byte[] var1);

        public byte[] decodeUrlSafe(byte[] var1);
    }
}

