/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.classproxy;

import com.firefly.utils.ReflectUtils;
import com.firefly.utils.StringUtils;
import com.firefly.utils.classproxy.AbstractMethodProxyFactory;
import com.firefly.utils.collection.ConcurrentReferenceHashMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.UUID;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;

public class MethodProxyFactoryUsingJavassist
extends AbstractMethodProxyFactory {
    private static final Map<Method, ReflectUtils.MethodProxy> methodCache = new ConcurrentReferenceHashMap<Method, ReflectUtils.MethodProxy>(256);
    public static final MethodProxyFactoryUsingJavassist INSTANCE = new MethodProxyFactoryUsingJavassist();

    private MethodProxyFactoryUsingJavassist() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReflectUtils.MethodProxy getMethodProxy(Method method) throws Throwable {
        ReflectUtils.MethodProxy ret = methodCache.get(method);
        if (ret != null) {
            return ret;
        }
        Map<Method, ReflectUtils.MethodProxy> map = methodCache;
        synchronized (map) {
            ret = methodCache.get(method);
            if (ret != null) {
                return ret;
            }
            ret = this._getMethodProxy(method);
            methodCache.put(method, ret);
            return ret;
        }
    }

    private ReflectUtils.MethodProxy _getMethodProxy(Method method) throws Throwable {
        ClassPool classPool = ClassPool.getDefault();
        classPool.insertClassPath((ClassPath)new ClassClassPath(ReflectUtils.MethodProxy.class));
        CtClass cc = classPool.makeClass("com.firefly.utils.ProxyMethod" + UUID.randomUUID().toString().replace("-", ""));
        cc.addInterface(classPool.get(ReflectUtils.MethodProxy.class.getName()));
        cc.addField(CtField.make((String)"private java.lang.reflect.Method method;", (CtClass)cc));
        CtConstructor constructor = new CtConstructor(new CtClass[]{classPool.get(Method.class.getName())}, cc);
        constructor.setBody("{this.method = (java.lang.reflect.Method)$1;}");
        cc.addConstructor(constructor);
        cc.addMethod(CtMethod.make((String)"public java.lang.reflect.Method method(){return method;}", (CtClass)cc));
        cc.addMethod(CtMethod.make((String)this.createInvokeMethodCode(method), (CtClass)cc));
        ReflectUtils.MethodProxy ret = (ReflectUtils.MethodProxy)cc.toClass(classLoader, null).getConstructor(Method.class).newInstance(method);
        return ret;
    }

    private String createInvokeMethodCode(Method method) {
        Class<?>[] paramClazz = method.getParameterTypes();
        StringBuilder code = new StringBuilder();
        code.append("public Object invoke(Object obj, Object[] args){\n ");
        if (paramClazz.length > 0) {
            code.append('\t').append(StringUtils.replace("if(args == null || args.length != {})", paramClazz.length)).append("\n\t\t").append("throw new IllegalArgumentException(\"arguments error\");\n").append('\n');
        }
        boolean hasValueOf = false;
        code.append('\t');
        if (!method.getReturnType().equals(Void.TYPE)) {
            code.append("return ");
            if (method.getReturnType().isPrimitive()) {
                code.append(StringUtils.replace("(Object){}.valueOf(", primitiveWrapMap.get(method.getReturnType())));
                hasValueOf = true;
            }
        }
        if (Modifier.isStatic(method.getModifiers())) {
            code.append(method.getDeclaringClass().getCanonicalName());
        } else {
            code.append(StringUtils.replace("(({})obj)", method.getDeclaringClass().getCanonicalName()));
        }
        code.append('.').append(method.getName()).append('(');
        if (paramClazz.length > 0) {
            int max = paramClazz.length - 1;
            int i = 0;
            while (true) {
                Class<?> param;
                if ((param = paramClazz[i]).isPrimitive()) {
                    code.append(StringUtils.replace("(({})args[{}]).{}Value()", primitiveWrapMap.get(param), i, param.getCanonicalName()));
                } else {
                    code.append(StringUtils.replace("({})args[{}]", param.getCanonicalName(), i));
                }
                if (i == max) break;
                code.append(", ");
                ++i;
            }
        }
        if (hasValueOf) {
            code.append(")");
        }
        code.append(");\n");
        if (method.getReturnType().equals(Void.TYPE)) {
            code.append("\treturn null;\n");
        }
        code.append('}');
        String ret = code.toString();
        return ret;
    }
}

