/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.classproxy;

import com.firefly.utils.CompilerUtils;
import com.firefly.utils.ReflectUtils;
import com.firefly.utils.StringUtils;
import com.firefly.utils.classproxy.AbstractMethodProxyFactory;
import com.firefly.utils.collection.ConcurrentReferenceHashMap;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;

public class MethodProxyFactoryUsingJavaCompiler
extends AbstractMethodProxyFactory {
    private static final Map<Method, ReflectUtils.MethodProxy> methodCache = new ConcurrentReferenceHashMap<Method, ReflectUtils.MethodProxy>(256);
    public static final MethodProxyFactoryUsingJavaCompiler INSTANCE = new MethodProxyFactoryUsingJavaCompiler();

    private MethodProxyFactoryUsingJavaCompiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReflectUtils.MethodProxy getMethodProxy(Method method) throws Throwable {
        ReflectUtils.MethodProxy ret = methodCache.get(method);
        if (ret != null) {
            return ret;
        }
        Map<Method, ReflectUtils.MethodProxy> map = methodCache;
        synchronized (map) {
            ret = methodCache.get(method);
            if (ret != null) {
                return ret;
            }
            ret = this._getMethodProxy(method);
            methodCache.put(method, ret);
            return ret;
        }
    }

    private ReflectUtils.MethodProxy _getMethodProxy(Method method) throws Throwable {
        String source;
        Class<?> methodProxyClass;
        String packageName = "com.firefly.utils";
        String className = "MethodReflectionProxy" + UUID.randomUUID().toString().replace("-", "");
        String completeClassName = packageName + "." + className;
        Class<?>[] paramClazz = method.getParameterTypes();
        String returnCode = "";
        if (!method.getReturnType().equals(Void.TYPE)) {
            returnCode = returnCode + "return ";
        }
        returnCode = returnCode + "((" + method.getDeclaringClass().getCanonicalName() + ")obj)." + method.getName() + "(";
        if (paramClazz.length > 0) {
            int max = paramClazz.length - 1;
            int i = 0;
            while (true) {
                Class<?> param;
                returnCode = (param = paramClazz[i]).isPrimitive() ? returnCode + StringUtils.replace("(({})args[{}]).{}Value()", primitiveWrapMap.get(param), i, param.getCanonicalName()) : returnCode + "(" + param.getCanonicalName() + ")args[" + i + "]";
                if (i == max) break;
                returnCode = returnCode + ",";
                ++i;
            }
        }
        returnCode = returnCode + ");";
        if (method.getReturnType().equals(Void.TYPE)) {
            returnCode = returnCode + "\n\treturn null;";
        }
        if ((methodProxyClass = CompilerUtils.compileSource(completeClassName, source = "package " + packageName + ";\nimport " + Method.class.getCanonicalName() + ";\npublic class " + className + " implements " + ReflectUtils.MethodProxy.class.getCanonicalName() + " {\nprivate Method method;\npublic " + className + "(Method method){\n\tthis.method = method;\n}\n\npublic Method method(){return method;}\n\npublic Object invoke(Object obj, Object[] args){\n\tif(args == null || args.length != " + paramClazz.length + ")\n\t\tthrow new IllegalArgumentException(\"arguments error\");\n\n\t" + returnCode + "\n}\n}")) == null) {
            return null;
        }
        ReflectUtils.MethodProxy obj = (ReflectUtils.MethodProxy)methodProxyClass.getConstructor(Method.class).newInstance(method);
        return obj;
    }
}

