/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.classproxy;

import com.firefly.utils.ReflectUtils;
import com.firefly.utils.StringUtils;
import com.firefly.utils.classproxy.AbstractFieldProxyFactory;
import com.firefly.utils.collection.ConcurrentReferenceHashMap;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;

public class FieldProxyFactoryUsingJavassist
extends AbstractFieldProxyFactory {
    private static final Map<Field, ReflectUtils.FieldProxy> fieldCache = new ConcurrentReferenceHashMap<Field, ReflectUtils.FieldProxy>(256);
    public static final FieldProxyFactoryUsingJavassist INSTANCE = new FieldProxyFactoryUsingJavassist();

    private FieldProxyFactoryUsingJavassist() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReflectUtils.FieldProxy getFieldProxy(Field field) throws Throwable {
        ReflectUtils.FieldProxy ret = fieldCache.get(field);
        if (ret != null) {
            return ret;
        }
        Map<Field, ReflectUtils.FieldProxy> map = fieldCache;
        synchronized (map) {
            ret = fieldCache.get(field);
            if (ret != null) {
                return ret;
            }
            ret = this._getFieldProxy(field);
            fieldCache.put(field, ret);
            return ret;
        }
    }

    private ReflectUtils.FieldProxy _getFieldProxy(Field field) throws Throwable {
        ClassPool classPool = ClassPool.getDefault();
        classPool.insertClassPath((ClassPath)new ClassClassPath(ReflectUtils.FieldProxy.class));
        CtClass cc = classPool.makeClass("com.firefly.utils.ProxyField" + UUID.randomUUID().toString().replace("-", ""));
        cc.addInterface(classPool.get(ReflectUtils.FieldProxy.class.getName()));
        cc.addField(CtField.make((String)"private java.lang.reflect.Field field;", (CtClass)cc));
        CtConstructor constructor = new CtConstructor(new CtClass[]{classPool.get(Field.class.getName())}, cc);
        constructor.setBody("{this.field = (java.lang.reflect.Field)$1;}");
        cc.addConstructor(constructor);
        cc.addMethod(CtMethod.make((String)"public java.lang.reflect.Field field(){return field;}", (CtClass)cc));
        cc.addMethod(CtMethod.make((String)this.createFieldGetterMethodCode(field), (CtClass)cc));
        cc.addMethod(CtMethod.make((String)this.createFieldSetterMethodCode(field), (CtClass)cc));
        ReflectUtils.FieldProxy ret = (ReflectUtils.FieldProxy)cc.toClass(classLoader, null).getConstructor(Field.class).newInstance(field);
        return ret;
    }

    private String createFieldGetterMethodCode(Field field) {
        Class<?> fieldClazz = field.getType();
        StringBuilder code = new StringBuilder();
        code.append("public Object get(Object obj){\n").append("\treturn ");
        boolean hasValueOf = false;
        if (fieldClazz.isPrimitive()) {
            code.append(StringUtils.replace("(Object){}.valueOf(", primitiveWrapMap.get(fieldClazz)));
            hasValueOf = true;
        }
        code.append(StringUtils.replace("(({})obj).{}", field.getDeclaringClass().getCanonicalName(), field.getName()));
        if (hasValueOf) {
            code.append(")");
        }
        code.append(";\n").append("}");
        return code.toString();
    }

    private String createFieldSetterMethodCode(Field field) {
        Class<?> fieldClazz = field.getType();
        StringBuilder code = new StringBuilder();
        code.append("public void set(Object obj, Object value){\n");
        code.append(StringUtils.replace("\t(({})obj).{} = ", field.getDeclaringClass().getCanonicalName(), field.getName()));
        if (fieldClazz.isPrimitive()) {
            code.append(StringUtils.replace("(({})value).{}Value()", primitiveWrapMap.get(fieldClazz), fieldClazz.getCanonicalName()));
        } else {
            code.append(StringUtils.replace("({})value", fieldClazz.getCanonicalName()));
        }
        code.append(";\n").append("}");
        return code.toString();
    }
}

