/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.classproxy;

import com.firefly.utils.CompilerUtils;
import com.firefly.utils.ReflectUtils;
import com.firefly.utils.StringUtils;
import com.firefly.utils.classproxy.AbstractFieldProxyFactory;
import com.firefly.utils.collection.ConcurrentReferenceHashMap;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;

public class FieldProxyFactoryUsingJavaCompiler
extends AbstractFieldProxyFactory {
    private static final Map<Field, ReflectUtils.FieldProxy> fieldCache = new ConcurrentReferenceHashMap<Field, ReflectUtils.FieldProxy>(256);
    public static final FieldProxyFactoryUsingJavaCompiler INSTANCE = new FieldProxyFactoryUsingJavaCompiler();

    private FieldProxyFactoryUsingJavaCompiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReflectUtils.FieldProxy getFieldProxy(Field field) throws Throwable {
        ReflectUtils.FieldProxy ret = fieldCache.get(field);
        if (ret != null) {
            return ret;
        }
        Map<Field, ReflectUtils.FieldProxy> map = fieldCache;
        synchronized (map) {
            ret = fieldCache.get(field);
            if (ret != null) {
                return ret;
            }
            ret = this._getFieldProxy(field);
            fieldCache.put(field, ret);
            return ret;
        }
    }

    private ReflectUtils.FieldProxy _getFieldProxy(Field field) throws Throwable {
        String packageName = "com.firefly.utils";
        String className = "FieldReflectionProxy" + UUID.randomUUID().toString().replace("-", "");
        String completeClassName = packageName + "." + className;
        String value = "";
        Class<?> fieldClazz = field.getType();
        value = fieldClazz.isPrimitive() ? value + StringUtils.replace("(({})value).{}Value()", primitiveWrapMap.get(fieldClazz), fieldClazz.getCanonicalName()) : value + StringUtils.replace("({})value", fieldClazz.getCanonicalName());
        String source = "package " + packageName + ";\nimport " + Field.class.getCanonicalName() + ";\npublic class " + className + " implements " + ReflectUtils.FieldProxy.class.getCanonicalName() + " {\nprivate Field field;\npublic " + className + "(Field field){\n\tthis.field = field;\n}\n\npublic Field field(){return field;}\npublic Object get(Object obj){\n\treturn " + StringUtils.replace("(({})obj).{};\n", field.getDeclaringClass().getCanonicalName(), field.getName()) + "}\n\npublic void set(Object obj, Object value){\n" + StringUtils.replace("\t(({})obj).{} = ", field.getDeclaringClass().getCanonicalName(), field.getName()) + value + ";\n}\n}";
        Class<?> fieldProxyClass = CompilerUtils.compileSource(completeClassName, source);
        if (fieldProxyClass == null) {
            return null;
        }
        ReflectUtils.FieldProxy fieldProxy = (ReflectUtils.FieldProxy)fieldProxyClass.getConstructor(Field.class).newInstance(field);
        return fieldProxy;
    }
}

