/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.classproxy;

import com.firefly.utils.ReflectUtils;
import com.firefly.utils.StringUtils;
import com.firefly.utils.classproxy.AbstractProxyFactory;
import com.firefly.utils.classproxy.ClassProxy;
import com.firefly.utils.classproxy.ClassProxyFactory;
import com.firefly.utils.classproxy.MethodFilter;
import com.firefly.utils.classproxy.MethodProxyFactoryUsingJavassist;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.UUID;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;

public class ClassProxyFactoryUsingJavassist
implements ClassProxyFactory {
    public static final ClassProxyFactoryUsingJavassist INSTANCE = new ClassProxyFactoryUsingJavassist();
    public static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    private ClassProxyFactoryUsingJavassist() {
    }

    @Override
    public Object createProxy(Object instance, ClassProxy proxy, MethodFilter filter) throws Throwable {
        ClassPool classPool = ClassPool.getDefault();
        classPool.insertClassPath((ClassPath)new ClassClassPath(ClassProxyFactory.class));
        Class<?> clazz = instance.getClass();
        CtClass cc = classPool.makeClass("com.firefly.utils.ClassProxy" + UUID.randomUUID().toString().replace("-", ""));
        cc.setSuperclass(classPool.get(clazz.getName()));
        cc.addField(CtField.make((String)("private " + ClassProxy.class.getCanonicalName() + " classProxy;"), (CtClass)cc));
        cc.addField(CtField.make((String)("private " + clazz.getCanonicalName() + " originalInstance;"), (CtClass)cc));
        cc.addField(CtField.make((String)("private " + ReflectUtils.MethodProxy[].class.getCanonicalName() + " methodProxies;"), (CtClass)cc));
        CtConstructor empty = new CtConstructor(null, cc);
        empty.setBody("{}");
        CtConstructor constructor = new CtConstructor(new CtClass[]{classPool.get(ClassProxy.class.getName()), classPool.get(clazz.getName()), classPool.get(ReflectUtils.MethodProxy[].class.getName())}, cc);
        constructor.setBody("{this.classProxy = (" + ClassProxy.class.getCanonicalName() + ")$1;this.originalInstance = (" + clazz.getCanonicalName() + ")$2;this.methodProxies = (" + ReflectUtils.MethodProxy[].class.getCanonicalName() + ")$3;}");
        cc.addConstructor(empty);
        cc.addConstructor(constructor);
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : clazz.getMethods()) {
            if (m.getDeclaringClass().equals(Object.class) || Modifier.isFinal(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || Modifier.isNative(m.getModifiers()) || filter != null && !filter.accept(m)) continue;
            list.add(m);
        }
        Method[] methods = list.toArray(new Method[0]);
        ReflectUtils.MethodProxy[] methodProxies = new ReflectUtils.MethodProxy[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            Method m;
            m = methods[i];
            methodProxies[i] = MethodProxyFactoryUsingJavassist.INSTANCE.getMethodProxy(m);
            String parameterArray = "Object[] args = new Object[]{";
            String str = "public " + m.getReturnType().getCanonicalName() + " " + m.getName() + "(";
            Class<?>[] parameters = m.getParameterTypes();
            for (int j = 0; j < parameters.length; ++j) {
                if (j != 0) {
                    str = str + ", ";
                    parameterArray = parameterArray + ", ";
                }
                str = str + parameters[j].getCanonicalName() + " arg" + j;
                parameterArray = parameters[j].isPrimitive() ? parameterArray + StringUtils.replace("(Object){}.valueOf(", AbstractProxyFactory.primitiveWrapMap.get(parameters[j])) + "arg" + j + ")" : parameterArray + "(Object)arg" + j;
            }
            str = str + "){\n";
            parameterArray = parameterArray + "};\n";
            if (parameters.length == 0) {
                parameterArray = Object[].class.getCanonicalName() + " args = new Object[0];\n";
            }
            str = str + "\t" + parameterArray;
            if (!m.getReturnType().equals(Void.TYPE)) {
                str = m.getReturnType().isPrimitive() ? str + "\t" + m.getReturnType().getCanonicalName() + " ret = ((" + AbstractProxyFactory.primitiveWrapMap.get(m.getReturnType()) + ")classProxy.intercept(methodProxies[" + i + "], originalInstance, args))." + m.getReturnType().getCanonicalName() + "Value();\n" : str + "\t" + m.getReturnType().getCanonicalName() + " ret = (" + m.getReturnType().getCanonicalName() + ")classProxy.intercept(methodProxies[" + i + "], originalInstance, args);\n";
                str = str + "\treturn ret;\n";
            } else {
                str = str + "\tclassProxy.intercept(methodProxies[" + i + "], originalInstance, args);\n";
            }
            str = str + "}";
            cc.addMethod(CtMethod.make((String)str, (CtClass)cc));
        }
        Object ret = cc.toClass(classLoader, null).getConstructor(ClassProxy.class, clazz, ReflectUtils.MethodProxy[].class).newInstance(proxy, instance, methodProxies);
        return ret;
    }
}

