/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.classproxy;

import com.firefly.utils.ReflectUtils;
import com.firefly.utils.StringUtils;
import com.firefly.utils.classproxy.AbstractArrayProxyFactory;
import com.firefly.utils.collection.ConcurrentReferenceHashMap;
import java.util.Map;
import java.util.UUID;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;

public class ArrayProxyFactoryUsingJavassist
extends AbstractArrayProxyFactory {
    private static final Map<Class<?>, ReflectUtils.ArrayProxy> arrayCache = new ConcurrentReferenceHashMap(256);
    public static final ArrayProxyFactoryUsingJavassist INSTANCE = new ArrayProxyFactoryUsingJavassist();

    private ArrayProxyFactoryUsingJavassist() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReflectUtils.ArrayProxy getArrayProxy(Class<?> clazz) throws Throwable {
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("type error, it's not array");
        }
        ReflectUtils.ArrayProxy ret = arrayCache.get(clazz);
        if (ret != null) {
            return ret;
        }
        Map<Class<?>, ReflectUtils.ArrayProxy> map = arrayCache;
        synchronized (map) {
            ret = arrayCache.get(clazz);
            if (ret != null) {
                return ret;
            }
            ret = this._getArrayProxy(clazz);
            arrayCache.put(clazz, ret);
            return ret;
        }
    }

    private ReflectUtils.ArrayProxy _getArrayProxy(Class<?> clazz) throws Throwable {
        ClassPool classPool = ClassPool.getDefault();
        classPool.insertClassPath((ClassPath)new ClassClassPath(ReflectUtils.ArrayProxy.class));
        CtClass cc = classPool.makeClass("com.firefly.utils.ArrayField" + UUID.randomUUID().toString().replace("-", ""));
        cc.addInterface(classPool.get(ReflectUtils.ArrayProxy.class.getName()));
        cc.addMethod(CtMethod.make((String)this.createArraySizeCode(clazz), (CtClass)cc));
        cc.addMethod(CtMethod.make((String)this.createArrayGetCode(clazz), (CtClass)cc));
        cc.addMethod(CtMethod.make((String)this.createArraySetCode(clazz), (CtClass)cc));
        ReflectUtils.ArrayProxy ret = (ReflectUtils.ArrayProxy)cc.toClass(classLoader, null).getConstructor(new Class[0]).newInstance(new Object[0]);
        return ret;
    }

    private String createArraySetCode(Class<?> clazz) {
        StringBuilder code = new StringBuilder();
        code.append("public void set(Object array, int index, Object value){\n").append(StringUtils.replace("\t(({})array)[index] = ", clazz.getCanonicalName()));
        Class<?> componentType = clazz.getComponentType();
        if (componentType.isPrimitive()) {
            code.append(StringUtils.replace("(({})value).{}Value()", primitiveWrapMap.get(componentType), componentType.getCanonicalName()));
        } else {
            code.append(StringUtils.replace("({})value", componentType.getCanonicalName()));
        }
        code.append(";\n").append("}");
        return code.toString();
    }

    private String createArrayGetCode(Class<?> clazz) {
        StringBuilder code = new StringBuilder();
        code.append("public Object get(Object array, int index){\n").append("\treturn ");
        Class<?> componentType = clazz.getComponentType();
        boolean hasValueOf = false;
        if (componentType.isPrimitive()) {
            code.append(StringUtils.replace("(Object){}.valueOf(", primitiveWrapMap.get(componentType)));
            hasValueOf = true;
        }
        code.append(StringUtils.replace("(({})array)[index]", clazz.getCanonicalName()));
        if (hasValueOf) {
            code.append(")");
        }
        code.append(";\n").append("}");
        return code.toString();
    }

    private String createArraySizeCode(Class<?> clazz) {
        StringBuilder code = new StringBuilder();
        code.append("public int size(Object array){\n").append("\treturn ").append(StringUtils.replace("(({})array).length;\n", clazz.getCanonicalName())).append("}");
        return code.toString();
    }
}

