/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils.classproxy;

import com.firefly.utils.CompilerUtils;
import com.firefly.utils.ReflectUtils;
import com.firefly.utils.StringUtils;
import com.firefly.utils.classproxy.AbstractArrayProxyFactory;
import com.firefly.utils.collection.ConcurrentReferenceHashMap;
import java.util.Map;
import java.util.UUID;

public class ArrayProxyFactoryUsingJavaCompiler
extends AbstractArrayProxyFactory {
    private static final Map<Class<?>, ReflectUtils.ArrayProxy> arrayCache = new ConcurrentReferenceHashMap(256);
    public static final ArrayProxyFactoryUsingJavaCompiler INSTANCE = new ArrayProxyFactoryUsingJavaCompiler();

    private ArrayProxyFactoryUsingJavaCompiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReflectUtils.ArrayProxy getArrayProxy(Class<?> clazz) throws Throwable {
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("type error, it's not array");
        }
        ReflectUtils.ArrayProxy ret = arrayCache.get(clazz);
        if (ret != null) {
            return ret;
        }
        Map<Class<?>, ReflectUtils.ArrayProxy> map = arrayCache;
        synchronized (map) {
            ret = arrayCache.get(clazz);
            if (ret != null) {
                return ret;
            }
            ret = this._getArrayProxy(clazz);
            arrayCache.put(clazz, ret);
            return ret;
        }
    }

    private ReflectUtils.ArrayProxy _getArrayProxy(Class<?> clazz) throws Throwable {
        String packageName = "com.firefly.utils";
        String className = "ArrayReflectionProxy" + UUID.randomUUID().toString().replace("-", "");
        String completeClassName = packageName + "." + className;
        Class<?> componentType = clazz.getComponentType();
        String v = null;
        v = componentType.isPrimitive() ? StringUtils.replace("(({})value).{}Value()", primitiveWrapMap.get(componentType), componentType.getCanonicalName()) : "(" + clazz.getComponentType().getCanonicalName() + ")value;\n";
        String source = "package " + packageName + ";\npublic class " + className + " implements " + ReflectUtils.ArrayProxy.class.getCanonicalName() + " {\n@Override\npublic int size(Object array){\n\treturn ((" + clazz.getCanonicalName() + ")array).length;\n}\n\n@Override\npublic Object get(Object array, int index){\n\treturn ((" + clazz.getCanonicalName() + ")array)[index];\n}\n\n@Override\npublic void set(Object array, int index, Object value){\n\t((" + clazz.getCanonicalName() + ")array)[index] = " + v + ";}\n\n}";
        Class<?> arrayProxyClazz = CompilerUtils.compileSource(completeClassName, source);
        if (arrayProxyClazz == null) {
            return null;
        }
        ReflectUtils.ArrayProxy obj = (ReflectUtils.ArrayProxy)arrayProxyClazz.newInstance();
        return obj;
    }
}

