/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils;

import com.firefly.utils.StringUtils;

public abstract class VerifyUtils {
    public static boolean isNumeric(String str) {
        int i;
        if (VerifyUtils.isEmpty(str)) {
            return false;
        }
        char first = str.charAt(0);
        int n = i = first == '-' ? 1 : 0;
        while (i < str.length()) {
            if (!VerifyUtils.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isInteger(String str) {
        int i;
        if (VerifyUtils.isEmpty(str)) {
            return false;
        }
        char first = str.charAt(0);
        int n = i = first == '-' ? 1 : 0;
        while (i < str.length()) {
            if (!VerifyUtils.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        Long t = Long.parseLong(str);
        return t <= Integer.MAX_VALUE && t >= Integer.MIN_VALUE;
    }

    public static boolean isLong(String str) {
        int len;
        if (VerifyUtils.isEmpty(str)) {
            return false;
        }
        char first = str.charAt(0);
        char end = str.charAt(str.length() - 1);
        boolean j = end == 'l' || end == 'L';
        int n = len = j ? str.length() - 1 : str.length();
        for (int i = first == '-' ? 1 : 0; i < len; ++i) {
            if (VerifyUtils.isDigit(str.charAt(i))) continue;
            return false;
        }
        if (!j) {
            Long t = Long.parseLong(str);
            return t > Integer.MAX_VALUE || t < Integer.MIN_VALUE;
        }
        return true;
    }

    public static boolean isFloat(String str) {
        int i;
        if (VerifyUtils.isEmpty(str)) {
            return false;
        }
        char end = str.charAt(str.length() - 1);
        if (end != 'f' && end != 'F') {
            return false;
        }
        int point = 0;
        int n = i = str.charAt(0) == '-' ? 1 : 0;
        while (i < str.length() - 1) {
            char c = str.charAt(i);
            if (c == '.') {
                ++point;
            } else if (!VerifyUtils.isDigit(c)) {
                return false;
            }
            ++i;
        }
        return point == 1 || point == 0;
    }

    public static boolean isDouble(String str) {
        int i;
        if (VerifyUtils.isEmpty(str)) {
            return false;
        }
        int point = 0;
        int n = i = str.charAt(0) == '-' ? 1 : 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '.') {
                ++point;
            } else if (!VerifyUtils.isDigit(c)) {
                return false;
            }
            ++i;
        }
        return point == 1;
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isNotEmpty(Long o) {
        return o != null && StringUtils.hasText(o.toString());
    }

    public static boolean isNotEmpty(Integer o) {
        return o != null && StringUtils.hasText(o.toString());
    }

    public static boolean isNotEmpty(String o) {
        return StringUtils.hasText(o);
    }

    public static boolean isEmpty(Long o) {
        return !VerifyUtils.isNotEmpty(o);
    }

    public static boolean isEmpty(Integer o) {
        return !VerifyUtils.isNotEmpty(o);
    }

    public static boolean isEmpty(String o) {
        return !VerifyUtils.isNotEmpty(o);
    }
}

