/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils;

import com.firefly.utils.classproxy.ArrayProxyFactoryUsingJavassist;
import com.firefly.utils.classproxy.FieldProxyFactoryUsingJavassist;
import com.firefly.utils.classproxy.MethodProxyFactoryUsingJavassist;
import com.firefly.utils.collection.ConcurrentReferenceHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class ReflectUtils {
    private static final ConcurrentReferenceHashMap<Class<?>, Map<String, Method>> getterCache = new ConcurrentReferenceHashMap(256);
    private static final ConcurrentReferenceHashMap<Class<?>, Map<String, Method>> setterCache = new ConcurrentReferenceHashMap(256);
    private static final ConcurrentReferenceHashMap<Class<?>, Map<String, Field>> propertyCache = new ConcurrentReferenceHashMap(256);
    public static ProxyFactory defaultArrayProxy = ArrayProxyFactoryUsingJavassist.INSTANCE;
    public static ProxyFactory defaultFieldProxy = FieldProxyFactoryUsingJavassist.INSTANCE;
    public static ProxyFactory defaultMethodProxy = MethodProxyFactoryUsingJavassist.INSTANCE;

    public static void setProperty(Object obj, String property, Object value) throws Throwable {
        ReflectUtils.getFields(obj.getClass()).get(property).set(obj, value);
    }

    public static Object getProperty(Object obj, String property) throws Throwable {
        return ReflectUtils.getFields(obj.getClass()).get(property).get(obj);
    }

    public static void set(Object obj, String property, Object value) throws Throwable {
        ReflectUtils.getSetterMethod(obj.getClass(), property).invoke(obj, value);
    }

    public static Object get(Object obj, String property) throws Throwable {
        return ReflectUtils.getGetterMethod(obj.getClass(), property).invoke(obj, new Object[0]);
    }

    public static Object arrayGet(Object array, int index) throws Throwable {
        return ReflectUtils.getArrayProxy(array.getClass()).get(array, index);
    }

    public static void arraySet(Object array, int index, Object value) throws Throwable {
        ReflectUtils.getArrayProxy(array.getClass()).set(array, index, value);
    }

    public static int arraySize(Object array) throws Throwable {
        return ReflectUtils.getArrayProxy(array.getClass()).size(array);
    }

    public static ArrayProxy getArrayProxy(Class<?> clazz) throws Throwable {
        return defaultArrayProxy.getArrayProxy(clazz);
    }

    public static FieldProxy getFieldProxy(Field field) throws Throwable {
        return defaultFieldProxy.getFieldProxy(field);
    }

    public static MethodProxy getMethodProxy(Method method) throws Throwable {
        return defaultMethodProxy.getMethodProxy(method);
    }

    public static String[] getInterfaceNames(Class<?> c) {
        Class<?>[] interfaces = c.getInterfaces();
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> i : interfaces) {
            names.add(i.getName());
        }
        return names.toArray(new String[0]);
    }

    public static String getPropertyName(Method method) {
        String methodName;
        int index = (methodName = method.getName()).charAt(0) == 'i' ? 2 : 3;
        char c = methodName.charAt(index);
        if (Character.isLowerCase(c)) {
            return methodName.substring(index);
        }
        return Character.toLowerCase(methodName.charAt(index)) + methodName.substring(index + 1);
    }

    public static Method getSetterMethod(Class<?> clazz, String propertyName) {
        return ReflectUtils.getSetterMethods(clazz).get(propertyName);
    }

    public static Map<String, Method> getSetterMethods(Class<?> clazz) {
        return setterCache.get(clazz, key -> ReflectUtils.getSetterMethods(key, null));
    }

    public static Map<String, Method> getSetterMethods(Class<?> clazz, BeanMethodFilter filter) {
        Method[] methods;
        HashMap<String, Method> setMethodMap = new HashMap<String, Method>();
        for (Method method : methods = clazz.getMethods()) {
            method.setAccessible(true);
            if (method.getName().length() < 4 || !method.getName().startsWith("set") || Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 1) continue;
            String propertyName = ReflectUtils.getPropertyName(method);
            if (filter != null && !filter.accept(propertyName, method)) continue;
            setMethodMap.put(propertyName, method);
        }
        return setMethodMap;
    }

    public static Method getGetterMethod(Class<?> clazz, String propertyName) {
        return ReflectUtils.getGetterMethods(clazz).get(propertyName);
    }

    public static Map<String, Method> getGetterMethods(Class<?> clazz) {
        return getterCache.get(clazz, key -> ReflectUtils.getGetterMethods(key, null));
    }

    public static Map<String, Method> getGetterMethods(Class<?> clazz, BeanMethodFilter filter) {
        HashMap<String, Method> getMethodMap = new HashMap<String, Method>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            int index;
            Method method = methods[i];
            method.setAccessible(true);
            String methodName = method.getName();
            if (Modifier.isStatic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers()) || method.getName().equals("getClass") || !method.getName().startsWith("is") && !method.getName().startsWith("get") || method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
            int n = index = methodName.charAt(0) == 'i' ? 2 : 3;
            if (methodName.length() < index + 1) continue;
            String propertyName = ReflectUtils.getPropertyName(method);
            if (filter != null && !filter.accept(propertyName, method)) continue;
            getMethodMap.put(propertyName, method);
        }
        return getMethodMap;
    }

    public static Map<String, Field> getFields(Class<?> clazz) {
        return propertyCache.get(clazz, key -> ReflectUtils.getFields(key, null));
    }

    public static Map<String, Field> getFields(Class<?> clazz, BeanFieldFilter filter) {
        Field[] fields;
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field field : fields = clazz.getFields()) {
            field.setAccessible(true);
            if (Modifier.isStatic(field.getModifiers())) continue;
            String propertyName = field.getName();
            if (filter != null && !filter.accept(propertyName, field)) continue;
            fieldMap.put(propertyName, field);
        }
        return fieldMap;
    }

    public static void copy(Object src, Object dest) {
        Map<String, Method> getterMethodMap = ReflectUtils.getGetterMethods(src.getClass());
        Map<String, Method> setterMethodMap = ReflectUtils.getSetterMethods(dest.getClass());
        for (Map.Entry<String, Method> entry : setterMethodMap.entrySet()) {
            Method getter = getterMethodMap.get(entry.getKey());
            if (getter == null) continue;
            try {
                Object obj = getter.invoke(src, new Object[0]);
                if (obj == null) continue;
                entry.getValue().invoke(dest, obj);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static interface ProxyFactory {
        public ArrayProxy getArrayProxy(Class<?> var1) throws Throwable;

        public FieldProxy getFieldProxy(Field var1) throws Throwable;

        public MethodProxy getMethodProxy(Method var1) throws Throwable;
    }

    public static interface ArrayProxy {
        public int size(Object var1);

        public Object get(Object var1, int var2);

        public void set(Object var1, int var2, Object var3);
    }

    public static interface FieldProxy {
        public Field field();

        public Object get(Object var1);

        public void set(Object var1, Object var2);
    }

    public static interface MethodProxy {
        public Method method();

        public Object invoke(Object var1, Object ... var2);
    }

    public static interface BeanFieldFilter {
        public boolean accept(String var1, Field var2);
    }

    public static interface BeanMethodFilter {
        public boolean accept(String var1, Method var2);
    }
}

