/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils;

import com.firefly.utils.StringUtils;
import com.firefly.utils.ThreadLocalRandom;

public abstract class RandomUtils {
    public static final String ALL_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static long random(long min, long max) {
        return Math.round(ThreadLocalRandom.current().nextDouble() * (double)(max - min) + (double)min);
    }

    public static int randomSegment(String conf) {
        String[] tmp = StringUtils.split(conf, ":");
        int[] probability = new int[tmp.length];
        for (int i = 0; i < probability.length; ++i) {
            probability[i] = Integer.parseInt(tmp[i].trim());
        }
        return RandomUtils.randomSegment(probability);
    }

    public static int randomSegment(int[] probability) {
        int total = 0;
        for (int i = 0; i < probability.length; ++i) {
            probability[i] = total += probability[i];
        }
        int rand = (int)RandomUtils.random(0L, total - 1);
        for (int i = 0; i < probability.length; ++i) {
            if (rand >= probability[i]) continue;
            return i;
        }
        return -1;
    }

    public static String randomString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = (int)RandomUtils.random(0L, ALL_CHAR.length() - 1);
            sb.append(ALL_CHAR.charAt(index));
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String conf = "100:1:32:200:16:30";
        System.out.println(RandomUtils.randomSegment(conf));
        System.out.println(RandomUtils.random(0L, 5L));
        System.out.println(RandomUtils.randomString(16));
    }
}

