/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.utils;

import com.firefly.utils.ReflectUtils;
import com.firefly.utils.StringUtils;
import com.firefly.utils.VerifyUtils;
import com.firefly.utils.collection.IdentityHashMap;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingDeque;

public abstract class ConvertUtils {
    private static final IdentityHashMap<Class<?>, ParseValue> map = new IdentityHashMap();
    private static final Map<String, ParseValue> map2 = new HashMap<String, ParseValue>();

    public static <T> T convert(String value, T defaultValue) {
        return (T)ConvertUtils.convert(value, defaultValue.getClass(), defaultValue);
    }

    public static <T> T convert(String value, Class<T> c, T defaultValue) {
        try {
            if (!StringUtils.hasText(value)) {
                return defaultValue;
            }
            T ret = ConvertUtils.convert(value, c);
            return ret != null ? ret : defaultValue;
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    public static <T> T convert(String value, Class<T> c) {
        ParseValue p;
        Object ret = null;
        ParseValue parseValue = p = c == null ? null : map.get(c);
        ret = p != null ? p.parse(value) : (VerifyUtils.isInteger(value) ? Integer.valueOf(Integer.parseInt(value)) : (VerifyUtils.isLong(value) ? Long.valueOf(Long.parseLong(value)) : (VerifyUtils.isDouble(value) ? Double.valueOf(Double.parseDouble(value)) : (VerifyUtils.isFloat(value) ? Float.valueOf(Float.parseFloat(value)) : value))));
        return (T)ret;
    }

    public static <T> T convert(String value, String argsType) {
        ParseValue p;
        Object ret = null;
        ParseValue parseValue = p = argsType == null ? null : map2.get(argsType);
        ret = p != null ? p.parse(value) : (VerifyUtils.isInteger(value) ? Integer.valueOf(Integer.parseInt(value)) : (VerifyUtils.isLong(value) ? Long.valueOf(Long.parseLong(value)) : (VerifyUtils.isDouble(value) ? Double.valueOf(Double.parseDouble(value)) : (VerifyUtils.isFloat(value) ? Float.valueOf(Float.parseFloat(value)) : value))));
        return (T)ret;
    }

    public static Object convert(Collection<?> collection, Class<?> arrayType) {
        int size = collection.size();
        Iterator<?> iterator = collection.iterator();
        Class componentType = null;
        if (arrayType == null) {
            componentType = Object.class;
        } else {
            if (!arrayType.isArray()) {
                throw new IllegalArgumentException("type is not a array");
            }
            componentType = arrayType.getComponentType();
        }
        Object newArray = Array.newInstance(componentType, size);
        for (int i = 0; i < size; ++i) {
            Object element = iterator.next();
            try {
                ReflectUtils.arraySet(newArray, i, element);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return newArray;
    }

    public static Collection<Object> getCollectionObj(Class<?> clazz) {
        if (clazz.isInterface()) {
            if (clazz.isAssignableFrom(List.class)) {
                return new ArrayList<Object>();
            }
            if (clazz.isAssignableFrom(Set.class)) {
                return new HashSet<Object>();
            }
            if (clazz.isAssignableFrom(Queue.class)) {
                return new ArrayDeque<Object>();
            }
            if (clazz.isAssignableFrom(SortedSet.class)) {
                return new TreeSet<Object>();
            }
            if (clazz.isAssignableFrom(BlockingQueue.class)) {
                return new LinkedBlockingDeque<Object>();
            }
            return null;
        }
        Collection collection = null;
        try {
            collection = (Collection)clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return collection;
    }

    public static Map<Object, Object> getMapObj(Class<?> clazz) {
        if (clazz.isInterface()) {
            if (clazz.isAssignableFrom(Map.class)) {
                return new HashMap<Object, Object>();
            }
            if (clazz.isAssignableFrom(ConcurrentMap.class)) {
                return new ConcurrentHashMap<Object, Object>();
            }
            if (clazz.isAssignableFrom(SortedMap.class)) {
                return new TreeMap<Object, Object>();
            }
            if (clazz.isAssignableFrom(NavigableMap.class)) {
                return new TreeMap<Object, Object>();
            }
            if (clazz.isAssignableFrom(ConcurrentNavigableMap.class)) {
                return new ConcurrentSkipListMap<Object, Object>();
            }
            return null;
        }
        Map map = null;
        try {
            map = (Map)clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static <T> Enumeration<T> enumeration(Collection<T> col) {
        final Iterator<T> it = col.iterator();
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public T nextElement() {
                return it.next();
            }
        };
    }

    static {
        ParseValue p = new ParseValue(){

            @Override
            public Object parse(String value) {
                return Integer.parseInt(value);
            }
        };
        map.put(Integer.TYPE, p);
        map.put(Integer.class, p);
        map2.put("byte", p);
        map2.put("java.lang.Byte", p);
        p = new ParseValue(){

            @Override
            public Object parse(String value) {
                return Long.parseLong(value);
            }
        };
        map.put(Long.TYPE, p);
        map.put(Long.class, p);
        map2.put("long", p);
        map2.put("java.lang.Long", p);
        p = new ParseValue(){

            @Override
            public Object parse(String value) {
                return Double.parseDouble(value);
            }
        };
        map.put(Double.TYPE, p);
        map.put(Double.class, p);
        map2.put("double", p);
        map2.put("java.lang.Double", p);
        p = new ParseValue(){

            @Override
            public Object parse(String value) {
                return Float.valueOf(Float.parseFloat(value));
            }
        };
        map.put(Float.TYPE, p);
        map.put(Float.class, p);
        map2.put("float", p);
        map2.put("java.lang.Float", p);
        p = new ParseValue(){

            @Override
            public Object parse(String value) {
                return Boolean.parseBoolean(value);
            }
        };
        map.put(Boolean.TYPE, p);
        map.put(Boolean.class, p);
        map2.put("boolean", p);
        map2.put("java.lang.Boolean", p);
        p = new ParseValue(){

            @Override
            public Object parse(String value) {
                return Short.parseShort(value);
            }
        };
        map.put(Short.TYPE, p);
        map.put(Short.class, p);
        map2.put("short", p);
        map2.put("java.lang.Short", p);
        p = new ParseValue(){

            @Override
            public Object parse(String value) {
                return Byte.parseByte(value);
            }
        };
        map.put(Byte.TYPE, p);
        map.put(Byte.class, p);
        map2.put("byte", p);
        map2.put("java.lang.Byte", p);
        p = new ParseValue(){

            @Override
            public Object parse(String value) {
                return value;
            }
        };
        map.put(String.class, p);
        map2.put("java.lang.String", p);
    }

    static interface ParseValue {
        public Object parse(String var1);
    }
}

